/* KinokoDataChecker.hh */
/* Created by Enomoto Sanshiro on 23 Septemter 2001. */
/* Last updated by Enomoto Sanshiro on 23 Septemter 2001. */


#ifndef __KinokoDataChecker_hh__
#define __KinokoDataChecker_hh__


#include <iostream>
#include <string>
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoDataChecker: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoDataChecker(void);
    virtual ~TKinokoDataChecker();
    virtual bool IsConditionSatisfied(void) = 0;
    friend class TKinokoComplexDataChecker;
};


class TKinokoElementDataChecker: public TKinokoDataChecker {
  public:
    TKinokoElementDataChecker(const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier, int Value, int OperatorId);
    TKinokoElementDataChecker(const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier, float Value, int OperatorId);
    virtual ~TKinokoElementDataChecker();
    virtual bool IsConditionSatisfied(void);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    int _IntValue, _IntData;
    float _FloatValue, _FloatData;
    int _OperatorId;
    bool _UseFloat;
  public:
    enum TOperatorId {
	Operator_Equal,
	Operator_NotEqual,
	Operator_GreaterThan,
	Operator_GreaterEqual,
	Operator_LessThan,
	Operator_LessEqual,
	Operator_BitAnd,
	Operator_BitXor,
	_NumbefOfOperators
    };
};


class TKinokoComplexDataChecker: public TKinokoDataChecker {
  public:
    TKinokoComplexDataChecker(TKinokoDataChecker* LeftDataChecker, TKinokoDataChecker* RightDataChecker, int OperatorId);
    virtual ~TKinokoComplexDataChecker();
    virtual void ReadDataSource(TKinokoDataSource* DataSource) throw(TKinokoException);
    virtual int ProcessDataPacket(void* DataPacket, TKinokoDataSource* DataSource = 0, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual int ProcessTrailerPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
    virtual bool IsConditionSatisfied(void);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    TKinokoDataChecker* _LeftDataChecker;
    TKinokoDataChecker* _RightDataChecker;
    int _OperatorId;
  public:
    enum TOperatorId {
	Operator_Not,
	Operator_And,
	Operator_Or,
	_NumbefOfOperators
    };
};


#endif
