/* KinokoHistogram2dWriter.hh */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#ifndef __KinokoHistogram2dWriter_hh__
#define __KinokoHistogram2dWriter_hh__


#include <string>
#include <vector>
#include "KameHistogram2d.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoHistogramWriter.hh"


class TKinokoHistogram2dWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoHistogram2dWriter(kame::TKameHistogram2d* Histogram, const std::string& SectionPathX, const TKinokoDataElementSpecifier& ElementSpecifierX, const std::string& SectionPathY, const TKinokoDataElementSpecifier& ElementSpecifierY);
    virtual ~TKinokoHistogram2dWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
    virtual int ProcessTrailer(int TrailerValue) throw(TKinokoException);
  protected:
    kame::TKameHistogram2d* _Histogram;
    std::string _SectionPathX, _SectionPathY;
    int _SectionIndexX, _SectionIndexY;
    TKinokoDataElementSpecifier _ElementSpecifierX, _ElementSpecifierY;
    std::string _TargetName;
    std::vector<double> _XDataList;
    std::vector<double> _YDataList;
};


#endif
