/* KinokoHistogramWriter.cc */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include <cmath>
#include "KameHistogram.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoHistogramWriter.hh"

using namespace std;
using namespace kame;


TKinokoHistogramWriter::TKinokoHistogramWriter(TKameHistogram* Histogram, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Histogram = Histogram;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";

    _StartTime = 0;
    _RunBeginCounts = 0;
}

TKinokoHistogramWriter::~TKinokoHistogramWriter()
{
}

void TKinokoHistogramWriter::Destroy(void)
{
}

void TKinokoHistogramWriter::Reset(void) throw(TKinokoException)
{
    _Histogram->Clear();    
}

int TKinokoHistogramWriter::ProcessCommandPacket(void* Packet, TKinokoDataSource* DataSource) throw(TKinokoException)
{
    int CommandValue = TKinokoDataStreamScanner::CommandValueOf(Packet);
    if (CommandValue == TKinokoDataStreamScanner::Command_RunBegin) {
	if (_RunBeginCounts == 0) {
	    _Histogram->Clear();
	    int EventTime = TKinokoDataStreamScanner::CommandTimeOf(Packet);
	    if (EventTime > 0) {
		_StartTime = EventTime;
	    }
	}
	_RunBeginCounts++;
    }

    return TKinokoSectionDataAnalyzer::ProcessCommandPacket(Packet, DataSource);
}

int TKinokoHistogramWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int NumberOfProcessedElements = 0;

    int Address; float Data;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
	_Histogram->Fill(Data);
	NumberOfProcessedElements++;
    }

    long TimeStamp = SectionData->GetEventTime();;
    long AccumulationTime = _Histogram->AccumulationTime();
    if ((_StartTime == 0) || (AccumulationTime < 0)) {
	//... FIX: _StartTime should be the time of RunBegin or clear() ...//
	_StartTime = TimeStamp;
    }
    if (_StartTime > 0) {
	_Histogram->SetAccumulationTime(TimeStamp - _StartTime);
    }

    return (NumberOfProcessedElements > 0) ? 1 : 0;
}

void TKinokoHistogramWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoHistogramWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillHistogram" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
