/* KinokoHistoryWriter.cc */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 29 September 2002. */


#include <iostream>
#include <string>
#include "KameHistory.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoHistoryWriter.hh"

using namespace std;
using namespace kame;


TKinokoHistoryWriter::TKinokoHistoryWriter(TKameHistory* History, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _History = History;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoHistoryWriter::~TKinokoHistoryWriter()
{
}

void TKinokoHistoryWriter::Destroy(void)
{
}

void TKinokoHistoryWriter::Reset(void) throw(TKinokoException)
{
    _History->Clear();
    _History->Start(TMushDateTime::SecSinceEpoch());
}

int TKinokoHistoryWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int NumberOfProcessedElements = 0;

    int Address; float Data;
    long TimeStamp = SectionData->GetEventTime();;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
        _History->Fill(Data, TimeStamp);
	NumberOfProcessedElements++;
    }

    return (NumberOfProcessedElements > 0) ? 1 : 0;
}

void TKinokoHistoryWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoHistoryWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillHistory" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
