/* KinokoMapWriter.cc */
/* Created by Enomoto Sanshiro on 2 April 2001. */
/* Last updated by Enomoto Sanshiro on 27 June 2002. */


#include <string>
#include "KameNtuple.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoMapWriter.hh"

using namespace std;
using namespace kame;


TKinokoMapWriter::TKinokoMapWriter(TKameNtuple* Ntuple, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Ntuple = Ntuple;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoMapWriter::~TKinokoMapWriter()
{
}

void TKinokoMapWriter::Destroy(void)
{
    TKinokoSectionDataAnalyzer::Destroy();
}

void TKinokoMapWriter::Reset(void) throw(TKinokoException)
{
    _Ntuple->Clear();
}

int TKinokoMapWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int NumberOfProcessedElements = 0;

    int Address; float Data; unsigned Index;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
	Index = _Ntuple->NumberOfRows();
	(*_Ntuple)[Index][0] = Address;
	(*_Ntuple)[Index][1] = Data;
	NumberOfProcessedElements++;
    }

    return (NumberOfProcessedElements > 0) ? 1 : 0;
}

void TKinokoMapWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoMapWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillMap" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\"";
    os << endl;
}
