/* KinokoTabularWriter.cc */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Updated by Enomoto Sanshiro on 27 June 2002. */
/* Last updated by Enomoto Sanshiro on 15 July 2009. */


#include <sstream>
#include <string>
#include "KameNtuple.hh"
#include "KinokoSectionDataAnalyzer.hh"
#include "KinokoTabularWriter.hh"

using namespace std;
using namespace kame;


TKinokoTabularWriter::TKinokoTabularWriter(TKameNtuple* Ntuple, const string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier)
{
    _Ntuple = Ntuple;
    _SectionPath = SectionPath;
    _ElementSpecifier = ElementSpecifier;

    AddSection(SectionPath);

    _TargetName = "untitled";
}

TKinokoTabularWriter::~TKinokoTabularWriter()
{
}

void TKinokoTabularWriter::Destroy(void)
{
    TKinokoSectionDataAnalyzer::Destroy();
}

void TKinokoTabularWriter::Reset(void) throw(TKinokoException)
{
    _Ntuple->Clear();
}

int TKinokoTabularWriter::ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException)
{
    int NumberOfProcessedElements = 0;

    string FieldName, Data;
    int Address;
    unsigned Index;
    while (SectionData->GetNextOf(_ElementSpecifier, Address, Data)) {
	FieldName = SectionData->NameOf(Address);
	Index = _Ntuple->NumberOfRows();
	(*_Ntuple)[Index][0] = FieldName;
	(*_Ntuple)[Index][1] = Data;
	NumberOfProcessedElements++;
    }

    return (NumberOfProcessedElements > 0) ? 1 : 0;
}

void TKinokoTabularWriter::SetTargetName(const std::string& Name)
{
    _TargetName = Name;
}

void TKinokoTabularWriter::Dump(ostream& os, const string& Indent)
{
    os << Indent << "FillTabular" << "\t" << _TargetName;
    os << ", \"" << _SectionPath << "\", " << _ElementSpecifier.AsString();
    os << endl;
}
