/* KinokoTabularWriter.hh */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Updated by Enomoto Sanshiro on 27 June 2002. */
/* Last updated by Enomoto Sanshiro on 15 July 2009. */


#ifndef __KinokoTabularWriter_hh__
#define __KinokoTabularWriter_hh__


#include <string>
#include "KameNtuple.hh"
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoTabularWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoTabularWriter(kame::TKameNtuple* Ntuple, const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier);
    virtual ~TKinokoTabularWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    kame::TKameNtuple* _Ntuple;
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    std::string _TargetName;
};


#endif
