/* KinokoTrendWriter.hh */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Updated by Enomoto Sanshiro on 29 September 2002. */
/* Last updated by Enomoto Sanshiro on 13 February 2008. */


#ifndef __KinokoTrendWriter_hh__
#define __KinokoTrendWriter_hh__


#include <iostream>
#include <string>
#include "KameTrend.hh"
#include "KinokoSectionDataAnalyzer.hh"


class TKinokoTrendWriter: public TKinokoSectionDataAnalyzer {
  public:
    TKinokoTrendWriter(kame::TKameTrend* Trend, const std::string& SectionPath, const TKinokoDataElementSpecifier& ElementSpecifier);
    virtual ~TKinokoTrendWriter();
    virtual void Destroy(void);
    virtual void Reset(void) throw(TKinokoException);
    virtual void SetTargetName(const std::string& Name);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
    virtual int ProcessCommandPacket(void* Packet, TKinokoDataSource* DataSource = 0) throw(TKinokoException);
  protected:
    virtual int ProcessData(TKinokoSectionData* SectionData) throw(TKinokoException);
  protected:
    kame::TKameTrend* _Trend;
    std::string _SectionPath;
    TKinokoDataElementSpecifier _ElementSpecifier;
    std::string _TargetName;
    int _RunBeginCounts;
};


#endif
