/* KinokoArena.hh */
/* Created by Enomoto Sanshiro on 19 April 1998. */
/* Updated by Enomoto Sanshiro on 15 January 2002. */
/* Last updated by Enomoto Sanshiro on 16 January 2010. */


#define INLINE_KINOKO_ARENA 1


#ifndef __KinokoArena_hh__
#define __KinokoArena_hh__


#include <sys/types.h>
#include <deque>


#if INLINE_KINOKO_ARENA
#define INLINE inline
#else
#define INLINE 
#endif


class TKinokoArenaEntry {
  public:
    INLINE TKinokoArenaEntry(int EntryIndex);
    INLINE ~TKinokoArenaEntry();
    INLINE void Attach(off_t Offset, size_t Capacity, int NumberOfAttached);
    INLINE void Detach(void);
    INLINE void AddNext(TKinokoArenaEntry* Entry);
    INLINE int EntryIndex(void) const;
    INLINE off_t Offset(void) const;
    INLINE size_t Capacity(void) const;
    INLINE int ReferenceCount(void) const;
    INLINE TKinokoArenaEntry* Prev(void) const;
    INLINE TKinokoArenaEntry* Next(void) const;
  private:
    int _EntryIndex;
    off_t _Offset;
    size_t _Capacity;
    int _ReferenceCount;
    TKinokoArenaEntry* _PrevEntry;
    TKinokoArenaEntry* _NextEntry;
};


class TKinokoArenaEntryPool {
  public:
    TKinokoArenaEntryPool(void) {}
    ~TKinokoArenaEntryPool() {}
    INLINE void Initialize(unsigned InitialNumberOfEntries);
    INLINE void Finalize(void);
    INLINE TKinokoArenaEntry* AllocateEntry(void);
    INLINE void ReleaseEntry(TKinokoArenaEntry* Entry);
  private:
    unsigned _EntryTableSize, _NumberOfOccupied;
    std::deque<TKinokoArenaEntry> _EntryTable;
    std::deque<bool> _OccupancyTable;
    int _NextEntryIndex;
};


class TKinokoArena {
  public:
    TKinokoArena(void) {}
    ~TKinokoArena() {}
    INLINE void Initialize(size_t ArenaSize, unsigned InitialEntryTableSize = 0);
    INLINE void Finalize(void);
    INLINE bool CreateEntry(size_t Capacity, off_t& OffsetAddress, int NumberOfAttached = 1);
    INLINE bool DetachEntry(off_t OffsetAddress);
    INLINE size_t Capacity(void) const;
    INLINE size_t AvailableSize(void) const;
    INLINE size_t AvailableSize(off_t StartOffset) const;
    INLINE bool IsAllocatable(size_t Size) const;
    INLINE int NumberOfEntries(void) const;
    INLINE size_t UsedSize(void) const;
    INLINE off_t DataHeadOffset(void) const;
    INLINE off_t NextStartOffset(void) const;
  private:
    size_t _ArenaSize, _UsedSize;
    int _NumberOfEntries;
    TKinokoArenaEntryPool _EntryPool;
    TKinokoArenaEntry* _HeadEntry;
    TKinokoArenaEntry* _TailEntry;
};



class TKinokoArenaBinder {
  public:
    TKinokoArenaBinder(TKinokoArena& Arena): _Arena(Arena) {}
    ~TKinokoArenaBinder() {}
  public:
    INLINE void SetBaseAddress(void* BaseAddress);
    INLINE bool CreateEntry(size_t Capacity, void*& Address, int NumberOfAttached = 1);
    INLINE bool DetachEntry(const void* Address);
  private:
    TKinokoArena& _Arena;
    void* _BaseAddress;
};


#if INLINE_KINOKO_ARENA
#include "KinokoArena.cc"
#endif

#undef INLINE


#endif
