/* KinokoBuilderConfiguration.hh */
/* Created by Enomoto Sanshiro on 12 September 2009. */
/* Updated by Enomoto Sanshiro on 19 May 2010. */
/* Last updated by Enomoto Sanshiro on 7 July 2010. */


#ifndef __KinokoBuilderConfiguration_hh__
#define __KinokoBuilderConfiguration_hh__


#include <string>
#include "KiscConfigFile.hh"
#include "KinokoDefs.hh"
#include "KinokoHorizontalBuilder.hh"
#include "KinokoVerticalBuilder.hh"


class TKinokoBuilderConfiguration {
  public:
    TKinokoBuilderConfiguration(void) {}
    virtual ~TKinokoBuilderConfiguration() {}
    virtual void ConfigureBuilder(TKinokoBuilder* Builder, const std::string& BuilderName) throw(TKinokoException) = 0;
};


class TKinokoKiscBuilderConfiguration {
  public:
    TKinokoKiscBuilderConfiguration(TKiscConfigFile& ConfigFile);
    virtual ~TKinokoKiscBuilderConfiguration();
    virtual void ConfigureBuilder(TKinokoBuilder* Builder, const std::string& BuilderName) throw(TKinokoException);
  protected:
    virtual void ConfigureCommon(TKinokoBuilder* Builder, const std::string& BuilderName) throw(TKinokoException);
    virtual void ConfigureHorizontal(TKinokoHorizontalBuilder* Builder, const std::string& BuilderName) throw(TKinokoException);
    virtual void ConfigureVertical(TKinokoVerticalBuilder* Builder, const std::string& BuilderName) throw(TKinokoException);
  protected:
    TKiscConfigFile& _ConfigFile;
};


#endif
