/* KinokoBuilderInlet.hh */
/* Created by Enomoto Sanshiro on 26 April 2010. */
/* Last updated by Enomoto Sanshiro on 26 April 2010. */


#ifndef __KinokoBuilderInlet_hh__
#define __KinokoBuilderInlet_hh__

#include <string>
#include <iostream>
#include <vector>
#include <map>
#include "KinokoDataProcessor.hh"
#include "KinokoBuilderProcessor.hh"


class TKinokoBuilderInlet: protected TKinokoEventPieceDefs {
  public:
    TKinokoBuilderInlet(TKinokoEventFragmentProcessor* FragmentProcessor);
    virtual ~TKinokoBuilderInlet();
    virtual void SetLogger(TKinokoBuilderLogger* Logger);
    virtual void SetTargetDataSource(const std::string& DataSourceName);
    virtual void AddTargetDataSection(const std::string& DataSectionName, TStreamKey StreamKey = -1);
    virtual bool ProcessPacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    virtual void Construct(void) throw(TKinokoException);
    virtual void ProcessRunBegin(void) throw(TKinokoException);
    virtual void ProcessRunEnd(void) throw(TKinokoException);
    virtual bool ProcessDescriptorPacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual bool ProcessCommandPacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual bool ProcessDataPacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual bool ProcessTrailerPacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    TKinokoEventFragmentProcessor* _Processor;
    TKinokoBuilderLogger* _NullLogger;
    TKinokoBuilderLogger* _Logger;
  protected:
    std::string _DataSourceName;
    int _DataSourceId;
    std::vector<std::pair<std::string, TStreamKey> > _SectionNameList;
    std::map<int, TStreamKey> _StreamKeyTable;
  protected:
    bool _IsConstructed;
    int _RunBeginCount;
    TKinokoDataDescriptor* _DataDescriptor;
    TKinokoDataStreamScanner* _StreamScanner;
};


#endif
