/* KinokoBuilderLogger.cc */
/* Created by Enomoto Sanshiro on 24 August 2009. */
/* Last updated by Enomoto Sanshiro on 24 August 2009. */


#include <string>
#include <iostream>
#include "KinokoEventSorter.hh"
#include "KinokoBuilderLogger.hh"

using namespace std;


int TKinokoBuilderLogger::WriteInformation(const std::string& Message)
{
    return Write(Message, mlInformation);
}

int TKinokoBuilderLogger::WriteLog(const std::string& Message)
{
    return Write(Message, mlLog);
}

int TKinokoBuilderLogger::WriteWarning(const std::string& Message)
{
    return Write(Message, mlWarning);
}

int TKinokoBuilderLogger::WriteError(const std::string& Message)
{
    return Write(Message, mlError);
}

int TKinokoBuilderLogger::WritePanic(const std::string& Message)
{
    return Write(Message, mlPanic);
}



TKinokoBuilderOstreamLogger::TKinokoBuilderOstreamLogger(ostream& Output)
: _Output(Output)
{
}

TKinokoBuilderOstreamLogger::~TKinokoBuilderOstreamLogger()
{
}

int TKinokoBuilderOstreamLogger::Write(const std::string& Message, int MessageLevel)
{
    switch (MessageLevel) {
      case TKinokoBuilderLogger::mlInformation:
	_Output << "<I> "; break;
      case TKinokoBuilderLogger::mlLog:
	_Output << "<L> "; break;
      case TKinokoBuilderLogger::mlWarning:
	_Output << "<W> "; break;
      case TKinokoBuilderLogger::mlError:
	_Output << "<E> "; break;
      case TKinokoBuilderLogger::mlPanic:
	_Output << "<P> "; break;
      default:
	_Output << "<?> "; break;
    }

    _Output << Message << endl;

    return 1;
}



TKinokoBuilderNullLogger::TKinokoBuilderNullLogger(void) 
{
}

TKinokoBuilderNullLogger::~TKinokoBuilderNullLogger() 
{
}

int TKinokoBuilderNullLogger::Write(const std::string& Message, int MessageLevel) 
{ 
    return 0; 
}
