/* KinokoBuilderMonitor.hh */
/* Created by Enomoto Sanshiro on 1 September 2009. */
/* Last updated by Enomoto Sanshiro on 7 July 2010. */


#ifndef __KinokoBuilderMonitor_hh__
#define __KinokoBuilderMonitor_hh__

#include <string>
#include <iostream>
#include "KinokoEventPiece.hh"
#include "KinokoEventSorter.hh"
#include "KinokoBuilderLogger.hh"


class TKinokoBuilderMonitor: protected TKinokoEventPieceDefs {
  public:
    TKinokoBuilderMonitor(void);
    virtual ~TKinokoBuilderMonitor(void);
    virtual void SetSorter(const TKinokoEventSorter* Sorter);
    virtual void Report(void) {}
    virtual void Dump(std::ostream& Output);
  protected:
    const TKinokoEventSorter* _Sorter;
};


class TKinokoBuilderLoggingMonitor: public TKinokoBuilderMonitor {
  public:
    TKinokoBuilderLoggingMonitor(TKinokoBuilderLogger* Logger);
    virtual ~TKinokoBuilderLoggingMonitor();
    virtual void Report(void);
  protected:
    TKinokoBuilderLogger* _Logger;
};


#endif
