/* KinokoChannelWatcher.hh */
/* Created by Enomoto Sanshiro on 15 August 2009. */
/* Last updated by Enomoto Sanshiro on 20 June 2010. */


#ifndef __KinokoChannelWatcher_hh__
#define __KinokoChannelWatcher_hh__


class TKinokoChannelWatcher {
  public:
    TKinokoChannelWatcher(void);
    virtual ~TKinokoChannelWatcher();
    virtual void AddInvolvedEvent(void);
    virtual void AddAbsentEvent(void);
    virtual void AddAbandonedEvent(void);
    inline bool IsAlive(void) const;
    inline float Occupancy(void) const;
    inline long long AbsenceCount(void) const;
    inline long long SuspensionCount(void) const;
    inline long long AbandonedCount(void) const;
  protected:
    virtual void UpdateOccupancy(void);
  protected:
    bool _IsAlive;
    long long _NumberOfEvents, _NumberOfInvolved, _LengthOfAbsence;
    float _Occupancy;
    long long _SuspensionCount, _AbandonedCount;
  protected:
    int _ActivityWindowLength;
  public:
    static void SetDefaultActivityWindowLength(int WindowLength);
  protected:
    static int _DefaultActivityWindowLength;
};



inline bool TKinokoChannelWatcher::IsAlive(void) const
{
    return _IsAlive;
}

inline float TKinokoChannelWatcher::Occupancy(void) const
{
    return _Occupancy;
}

inline long long TKinokoChannelWatcher::AbsenceCount(void) const
{
    return _LengthOfAbsence;
}

inline long long TKinokoChannelWatcher::SuspensionCount(void) const
{
    return _SuspensionCount;
}

inline long long TKinokoChannelWatcher::AbandonedCount(void) const
{
    return _AbandonedCount;
}

#endif
