/* KinokoEventChopper.hh */
/* Created by Enomoto Sanshiro on 11 August 2009. */
/* Last updated by Enomoto Sanshiro on 7 March 2010. */


#ifndef __KinokoEventChopper_hh__
#define __KinokoEventChopper_hh__


#include <vector>
#include <map>
#include <set>
#include "KinokoDataChunk.hh"
#include "KinokoEventPiece.hh"
#include "KinokoEventPieceScanner.hh"
#include "KinokoBuilderProcessor.hh"


class TKinokoCarryOverTable: private TKinokoEventPieceDefs {
  public:
    TKinokoCarryOverTable(void);
    ~TKinokoCarryOverTable();
    void Put(TStreamKey StreamKey, const TKinokoDataChunk& DataChunk);
    bool Get(TStreamKey StreamKey, TKinokoDataChunk& DataChunk);
    std::set<TStreamKey> StreamKeySet(void);
  protected:
    std::map<TStreamKey, int> _KeyIndexTable;
    std::vector<char*> _BufferList;
    std::vector<size_t> _SizeList;
    std::vector<size_t> _CapacityList;
};


class TKinokoEventChopper: public TKinokoEventFragmentProcessor {
  public:
    TKinokoEventChopper(TKinokoEventPieceProcessor* PieceProcessor, TKinokoEventPieceScanner* PieceScanner);
    virtual ~TKinokoEventChopper();
  public:
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual int ProcessFragment(TStreamKey StreamKey, const TKinokoDataChunk& DataChunk);
  protected:
    TKinokoEventPieceProcessor* _PieceProcessor;
    TKinokoEventPieceScanner* _PieceScanner;
    TKinokoCarryOverTable _CarryOverTable;
    std::map<TStreamKey, TEventKey> _CorruptionCountTable;
    std::map<TStreamKey, std::pair<TChannelKey, TEventKey> > _LocationTable;
};


#endif
