/* KinokoEventEnvelope.hh */
/* Created by Enomoto Sanshiro on 3 September 2009. */
/* Last updated by Enomoto Sanshiro on 7 March 2010. */


#ifndef __KinokoEventEnvelope_hh__
#define __KinokoEventEnvelope_hh__

#include "KinokoDataProcessor.hh"
#include "KinokoTaggedDataSection.hh"
#include "KinokoBlockDataSection.hh"
#include "KinokoBuilderProcessor.hh"
#include "KinokoEventPiece.hh"


class TKinokoEventEnvelopeWriter: public TKinokoEventSegmentProcessor {
  public:
    TKinokoEventEnvelopeWriter(TKinokoDataSender* DataSender);
    virtual ~TKinokoEventEnvelopeWriter();
    virtual void BuildDataSource(TKinokoDataSource* DataSource);
  protected:
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual void ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize);
    virtual void ProcessEventEnd(void);
    virtual int ProcessSegment(const TKinokoEventSegment& EventSegment);
  private:
    TKinokoBlockDataSectionFormatter* _SegmentFormatter;
    TKinokoDataSender* _DataSender;
};


class TKinokoEventEnvelopeReader: protected TKinokoEventPieceDefs {
  public:
    TKinokoEventEnvelopeReader(TKinokoEventSegmentProcessor* SegmentProcessor);
    virtual ~TKinokoEventEnvelopeReader();
    virtual void SetLogger(TKinokoBuilderLogger* Logger);
    virtual void AddTargetDataSource(const std::string& DataSourceName, TStreamKey StreamKey = -1);
    virtual const std::vector<std::pair<std::string, TStreamKey> >& InputDataSourceNameList(void);
    virtual bool ProcessPacket(void* Packet, long PacketSize) throw(TKinokoException);
protected:
    virtual void Construct(void) throw(TKinokoException);
    virtual void ProcessRunBegin(void) throw(TKinokoException);
    virtual void ProcessRunEnd(void) throw(TKinokoException);
    virtual bool ProcessDescriptorPacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual bool ProcessCommandPacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual bool ProcessDataPacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual bool ProcessTrailerPacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    TKinokoEventSegmentProcessor* _Processor;
    TKinokoBuilderLogger* _NullLogger;
    TKinokoBuilderLogger* _Logger;
  protected:
    std::vector<std::pair<std::string, TStreamKey> > _DataSourceNameList;
    std::vector<std::pair<std::string, TStreamKey> > _ValidDataSourceNameList;
    std::map<int, int> _DataSourceIndexTable;
    std::vector<int> _SegmentSectionIdTable;
    std::vector<int> _CurrentEventKeyTable;
    std::vector<int> _StreamKeyTable;
  protected:
    bool _IsConstructed;
    int _RunBeginCount;
    TKinokoDataDescriptor* _DataDescriptor;
    TKinokoDataStreamScanner* _StreamScanner;
};


#endif
