/* KinokoEventPiece.hh */
/* Created by Enomoto Sanshiro on 15 August 2009. */
/* Last updated by Enomoto Sanshiro on 7 March 2010. */


#ifndef __KinokoEventPiece_hh__
#define __KinokoEventPiece_hh__

#include "KinokoDataChunk.hh"


//... TODO: this should be changed to a namespace ...//
class TKinokoEventPieceDefs {
  public:
    typedef long long TEventKey;
    typedef long TStreamKey;
    typedef TStreamKey TChannelKey;
    enum TPieceType {
	PieceType_Undefined = 0,
	PieceType_Normal = 1,
	PieceType_Padding = 2,
	PieceType_Unaligned = 3,
	PieceType_Corrupted = 4,
	_NumberOfPieceTypes
    };
    enum TPieceFlag {
	PieceFlag_PossiblyEarlyArrival = 0x01,
	PieceFlag_LastOfTheEvent = 0x02,
	_NumberOfPieceFlags
    };
};


class TKinokoEventPiece: public TKinokoDataChunk, public TKinokoEventPieceDefs {
  public:
    int PieceType;
    TStreamKey ChannelKey;
    TEventKey EventKey;
    int PieceFlag;
  public:
    TKinokoEventPiece(void) 
    {
	PieceType = PieceType_Undefined;
	PieceFlag = 0;
	ChannelKey = -1;
	EventKey = -1;
    }
    explicit TKinokoEventPiece(const TKinokoDataChunk& DataChunk) 
    : TKinokoDataChunk(DataChunk)
    {
	PieceType = PieceType_Undefined;
	PieceFlag = 0;
	ChannelKey = -1;
	EventKey = -1;
    }
    TKinokoEventPiece(const TKinokoEventPiece& EventPiece) 
    : TKinokoDataChunk(EventPiece)
    {
	PieceType = EventPiece.PieceType;
	PieceFlag = EventPiece.PieceFlag;
	ChannelKey = EventPiece.ChannelKey;
	EventKey = EventPiece.EventKey;
    }
};


#endif
