/* KinokoEventSegment.hh */
/* Created by Enomoto Sanshiro on 15 August 2009. */
/* Last updated by Enomoto Sanshiro on 6 April 2010. */


#ifndef __KinokoEventSegment_hh__
#define __KinokoEventSegment_hh__

#include "KinokoDataChunk.hh"
#include "KinokoEventPiece.hh"


class TKinokoEventSegment: public TKinokoDataChunk, public TKinokoEventPieceDefs {
  public:
    inline TKinokoEventSegment(const TKinokoDataChunk& DataChunk);
    inline TKinokoEventSegment(const TKinokoEventSegment& EventSegment);
    inline int PieceType(void) const;
    inline TEventKey EventKey(void) const;
    inline int NumberOfPieces(void) const;
    inline int TotalSize(void) const;
    inline void SetHeader(int PieceType, int NumberOfPieces, TEventKey EventKey);
  public:
    TStreamKey StreamKey;
};


inline TKinokoEventSegment::TKinokoEventSegment(const TKinokoDataChunk& DataChunk) 
: TKinokoDataChunk(DataChunk)
{
    StreamKey = -1;
}

inline TKinokoEventSegment::TKinokoEventSegment(const TKinokoEventSegment& EventSegment) 
: TKinokoDataChunk(EventSegment)
{
    StreamKey = EventSegment.StreamKey;
}

inline int TKinokoEventSegment::PieceType(void) const
{
    return (*this)[0] & 0x0000000f;
}

inline TKinokoEventSegment::TEventKey TKinokoEventSegment::EventKey(void) const
{
    register TEventKey EventKeyL = (*this)[1];
    register TEventKey EventKeyH = (*this)[2];
    return (EventKeyH << 32) | EventKeyL;
}

inline int TKinokoEventSegment::NumberOfPieces(void) const
{
    return ((*this)[0] >> 8) & 0x000fffff;
}

inline void TKinokoEventSegment::SetHeader(int PieceType, int NumberOfPieces, TEventKey EventKey)
{
    // MSB 4bit is 0x0f, LSB 4bit is not 0x0f; use it for error check //
    (*this)[0] = (
	(0x000f << 28) |                        //  4 bit header
	((NumberOfPieces & 0x000fffff) << 8) |	// 20 bit NPieces
	0 |                                     //  4 bit Reserved
	(PieceType & 0x000f)                    //  4 bit PieceType
    );
    (*this)[1] = (EventKey >> 0) & 0xffffffff;
    (*this)[2] = (EventKey >> 32) & 0xffffffff;
}

inline int TKinokoEventSegment::TotalSize(void) const
{
    return this->Size() - sizeof(U32bit) * (2 * NumberOfPieces() + 3);
}

#endif
