/* KinokoEventSegmentPacker.hh */
/* Created by Enomoto Sanshiro on 23 April 2010. */
/* Last updated by Enomoto Sanshiro on 23 April 2010. */


#ifndef __KinokoEventSegmentPacker_hh__
#define __KinokoEventSegmentPacker_hh__

#include <iostream>
#include "KinokoEventPiece.hh"
#include "KinokoBuilderProcessor.hh"


class TKinokoEventSegmentPacker: public TKinokoEventPieceProcessor {
  public:
    TKinokoEventSegmentPacker(TKinokoEventSegmentProcessor* SegmentProcessor, TStreamKey StreamKey = -1);
    virtual ~TKinokoEventSegmentPacker();
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual void ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize);
    virtual void ProcessEventEnd(void);
    virtual int ProcessPiece(const TKinokoEventPiece& EventPiece);
  protected:
    virtual int ProcessSinglePiece(const TKinokoEventPiece& EventPiece);
  protected:
    TKinokoEventSegmentProcessor* _SegmentProcessor;
    TStreamKey _StreamKey;
  private:
    U32bit* _Buffer;
    size_t _BufferSize;
    U32bit* _SinglePieceBuffer;
    size_t _SinglePieceBufferSize;
    size_t _CurrentSegmentSize;
    int _CurrentPieceType;
    int _CurrentEventNumberOfPieces;
    int _CurrentEventTotalSize;
    TEventKey _CurrentEventKey;
    U32bit* _CurrentSegmentIterator;
};


class TKinokoEventSegmentUnpacker: public TKinokoEventSegmentProcessor {
  public:
    TKinokoEventSegmentUnpacker(TKinokoEventPieceProcessor* PieceProcessor);
    virtual ~TKinokoEventSegmentUnpacker();
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual void ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize);
    virtual void ProcessEventEnd(void);
    virtual int ProcessSegment(const TKinokoEventSegment& EventSegment);
  protected:
    TKinokoEventPieceProcessor* _PieceProcessor;
};


class TKinokoEventSegmentConsolidator: public TKinokoEventSegmentProcessor {
  public:
    TKinokoEventSegmentConsolidator(TKinokoEventSegmentProcessor* OutputProcessor, TStreamKey StreamKey=-1);
    virtual ~TKinokoEventSegmentConsolidator();
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual void ProcessEventBegin(TEventKey EventKey, int PieceType, int NumberOfPieces, size_t TotalSize);
    virtual void ProcessEventEnd(void);
    virtual int ProcessSegment(const TKinokoEventSegment& EventSegment);
  protected:
    virtual int ProcessSingleSegment(const TKinokoEventSegment& EventSegment);
  protected:
    TKinokoEventSegmentProcessor* _OutputProcessor;
    TStreamKey _StreamKey;
  private:
    U32bit* _Buffer;
    size_t _BufferSize;
    int _CurrentPieceType;
    int _CurrentEventNumberOfPieces;
    int _CurrentEventTotalSize;
    size_t _CurrentSegmentSize;
    TEventKey _CurrentEventKey;
    U32bit* _CurrentSegmentIterator;
};


#endif
