/* KinokoEventSorter.hh */
/* Created by Enomoto Sanshiro on 15 August 2009. */
/* Last updated by Enomoto Sanshiro on 7 March 2010. */


#ifndef __KinokoEventSorter_hh__
#define __KinokoEventSorter_hh__

#include <iostream>
#include <vector>
#include <deque>
#include <map>
#include <set>
#include "KinokoArena.hh"
#include "KinokoEventPiece.hh"
#include "KinokoChannelWatcher.hh"
#include "KinokoBuilderProcessor.hh"


class TKinokoEventSorterContext: public TKinokoEventPieceDefs {
  public:
    TKinokoEventSorterContext(void);
    virtual ~TKinokoEventSorterContext();
    virtual int RegisterChannel(TChannelKey ChannelKey);
    virtual void DumpStatusTo(std::ostream& os);
    virtual void DumpChannelStatTo(std::ostream& os);
protected:
    TEventKey _LastBuiltEventKey, _LastReceivedEventKey;
    TEventKey _NumberOfBuiltEvents;
    std::map<TEventKey, std::pair<int, size_t> > _HoldingEventSet;
    std::map<TChannelKey, int> _ChannelIndexTable;
    std::vector<TChannelKey> _ChannelKeyList;
    std::vector<TKinokoChannelWatcher> _ChannelWatcherList;
    std::vector<TEventKey> _CompleteEventKeyList;
    std::vector<std::deque<TEventKey> > _EventKeyQueueList;
    std::vector<std::set<TEventKey> > _EarlyArrivalEventKeySetList;
    std::vector<long> _ChannelEventCountList, _ChannelPieceCountList;
    std::vector<long> _LateArrivalLengthList;
  public:
    inline int NumberOfBuiltEvents(void) const {
	return _NumberOfBuiltEvents;
    }
    inline TEventKey LastBuiltEventKey(void) const {
	return _LastBuiltEventKey;
    }
    inline TEventKey LastEventKey(void) const {
	return _LastReceivedEventKey;
    }
    inline const std::map<TEventKey, std::pair<int, size_t> >& HoldingEventSet(void) const {
	return _HoldingEventSet;
    }
    inline const std::vector<TChannelKey>& ChannelKeyList(void) const {
	return _ChannelKeyList;
    }
    inline const std::vector<TKinokoChannelWatcher>& ChannelWatcherList(void) const {
	return _ChannelWatcherList;
    }
    inline const std::vector<TEventKey>& CompleteEventKeyList(void) const {
	return _CompleteEventKeyList;
    }
    inline const std::vector<std::deque<TEventKey> >& EventKeyQueueList(void) const {
	return _EventKeyQueueList;
    }
    inline const std::vector<std::set<TEventKey> >& EarlyArrivalEventKeySetList(void) const {
	return _EarlyArrivalEventKeySetList;
    }
    inline const std::vector<long>& ChannelEventCountList(void) const {
	return _ChannelEventCountList;
    }
    inline const std::vector<long>& ChannelPieceCountList(void) const {
	return _ChannelPieceCountList;
    }
};


class TKinokoEventSorter: public TKinokoEventPieceProcessor, public TKinokoEventSorterContext {
  public:
    TKinokoEventSorter(TKinokoEventPieceProcessor* OutputPieceProcessor, void* Buffer, TKinokoArena& Arena);
    virtual ~TKinokoEventSorter();
    virtual int RegisterChannel(TChannelKey ChannelKey);
    virtual const TKinokoArena& Arena(void) const;
  public:
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual int ProcessPiece(const TKinokoEventPiece& EventPiece);
  public:
    virtual int BuildOne(TEventKey EventKey = -1);
    virtual int BuildReadies(void);
    virtual int BuildAll(void);
  protected:
    TKinokoArena& _Arena;
    TKinokoArenaBinder _ArenaBinder;
    int _BufferReserveSize;
    TKinokoEventPieceProcessor* _OutputPieceProcessor;
    std::vector<std::deque<std::pair<void*, size_t> > > _EventPieceQueueList;
    std::vector<std::multimap<TEventKey, std::pair<void*, size_t> > > _EarlyArrivalPieceSetList;
};


#endif
