/* KinokoHorizontalBuilder.cc */
/* Created by Enomoto Sanshiro on 25 August 2009. */
/* Last updated by Enomoto Sanshiro on 8 May 2010. */


#include <string>
#include <iostream>
#include <vector>
#include "KinokoBuilderInlet.hh"
#include "KinokoEventChopper.hh"
#include "KinokoEventSorter.hh"
#include "KinokoSorterProcessor.hh"
#include "KinokoBuilder.hh"
#include "KinokoHorizontalBuilder.hh"

using namespace std;


TKinokoHorizontalBuilder::TKinokoHorizontalBuilder(void)
{
    _PieceScanner = 0;

    _BuilderInlet = 0;
    _Chopper = 0;
    _Sorter = 0;
}

TKinokoHorizontalBuilder::~TKinokoHorizontalBuilder()
{
    delete _BuilderInlet;
    delete _Chopper;
    delete _Sorter;
}

void TKinokoHorizontalBuilder::SetPieceScanner(TKinokoEventPieceScanner* Scanner)
{
    _PieceScanner = Scanner;
}

void TKinokoHorizontalBuilder::SetTargetDataSource(const std::string& DataSourceName)
{
    _InputDataSourceName = DataSourceName;
}

void TKinokoHorizontalBuilder::AddTargetDataSection(const std::string& DataSectionName, TStreamKey StreamKey)
{
    _InputDataSectionNameList.push_back(make_pair(DataSectionName, StreamKey));
}

TKinokoEventSorter& TKinokoHorizontalBuilder::BuilderConstruct(void) throw(TKinokoException) 
{
    if (_PieceScanner == 0) {
	throw TKinokoException(
	    "TKinokoHorizontalBuilder::OnConstruct()",
	    "User Event-Piece-Scanner not registered"
	);
    }

    _Sorter = new TKinokoEventPieceSorter(_EnvelopeWriter, _Buffer, _Arena);
    _Sorter->SetLogger(_Logger);

    _Chopper = new TKinokoEventChopper(_Sorter, _PieceScanner);
    _Chopper->SetLogger(_Logger);

    _BuilderInlet = new TKinokoBuilderInlet(_Chopper);
    _BuilderInlet->SetLogger(_Logger);

    _BuilderInlet->SetTargetDataSource(_InputDataSourceName);
    for (unsigned i = 0; i < _InputDataSectionNameList.size(); i++) {
	_BuilderInlet->AddTargetDataSection(
	    _InputDataSectionNameList[i].first,
	    _InputDataSectionNameList[i].second
	);
    }

    return _Sorter->Sorter();
}

void TKinokoHorizontalBuilder::BuilderBegin(void) throw(TKinokoException)
{
}

void TKinokoHorizontalBuilder::BuilderEnd(void) throw(TKinokoException)
{
}

int TKinokoHorizontalBuilder::BuilderProcess(void* Packet, long PacketSize) throw(TKinokoException)
{
    return _BuilderInlet->ProcessPacket(Packet, PacketSize);
}
