/* KinokoHorizontalBuilder.hh */
/* Created by Enomoto Sanshiro on 25 August 2009. */
/* Last updated by Enomoto Sanshiro on 8 May 2010. */


#ifndef __KinokoHorizontalBuilder_hh__
#define __KinokoHorizontalBuilder_hh__


#include <string>
#include <iostream>
#include <vector>
#include "KinokoBuilderInlet.hh"
#include "KinokoEventChopper.hh"
#include "KinokoEventSorter.hh"
#include "KinokoSorterProcessor.hh"
#include "KinokoBuilder.hh"


class TKinokoHorizontalBuilder: public TKinokoBuilder {
  public:
    TKinokoHorizontalBuilder(void);
    virtual ~TKinokoHorizontalBuilder();
    virtual void SetTargetDataSource(const std::string& DataSourceName);
    virtual void AddTargetDataSection(const std::string& DataSectionName, TStreamKey StreamKey = -1);
    virtual void SetPieceScanner(TKinokoEventPieceScanner* Scanner);
  protected:
    virtual TKinokoEventSorter& BuilderConstruct(void) throw(TKinokoException);
    virtual void BuilderBegin(void) throw(TKinokoException);
    virtual void BuilderEnd(void) throw(TKinokoException);
    virtual int BuilderProcess(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    TKinokoEventChopper* _Chopper;
    TKinokoEventPieceSorter* _Sorter;
    TKinokoEventPieceScanner* _PieceScanner;
  protected:
    std::string _InputDataSourceName;
    std::vector<std::pair<std::string, TStreamKey> > _InputDataSectionNameList;
    TKinokoBuilderInlet* _BuilderInlet;
};


#endif
