/* KinokoSorterProcessor.hh */
/* Created by Enomoto Sanshiro on 23 April 2010. */
/* Last updated by Enomoto Sanshiro on 5 May 2010. */


#ifndef __KinokoSorterProcessor_hh__
#define __KinokoSorterProcessor_hh__

#include "KinokoEventSorter.hh"
#include "KinokoBuilderProcessor.hh"


class TKinokoEventPieceSorter: public TKinokoEventPieceProcessor {
  public:
    TKinokoEventPieceSorter(TKinokoEventSegmentProcessor* OutputSegmentProcessor, void* Buffer, TKinokoArena& Arena);
    virtual ~TKinokoEventPieceSorter();
    inline TKinokoEventSorter& Sorter(void) { return _Sorter; }
  public:
    virtual void SetLogger(TKinokoBuilderLogger* Logger);
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual int ProcessPiece(const TKinokoEventPiece& EventPiece);
  protected:
    TKinokoEventSorter _Sorter;
    TKinokoEventPieceProcessor* _Packer;
};



class TKinokoEventSegmentSorter: public TKinokoEventSegmentProcessor {
  public:
    TKinokoEventSegmentSorter(TKinokoEventSegmentProcessor* OutputSegmentProcessor, void* Buffer, TKinokoArena& Arena);
    virtual ~TKinokoEventSegmentSorter();
    inline TKinokoEventSorter& Sorter(void) { return _Sorter; }
  public:
    virtual void SetLogger(TKinokoBuilderLogger* Logger);
    virtual void ProcessRunBegin(void);
    virtual void ProcessRunEnd(void);
    virtual int ProcessSegment(const TKinokoEventSegment& EventSegment);
  protected:
    TKinokoEventSorter _Sorter;
    TKinokoEventPieceProcessor* _Stripper;
    TKinokoEventSegmentProcessor* _Consolidator;
};


#endif
