/* KinokoVerticalBuilder.cc */
/* Created by Enomoto Sanshiro on 28 August 2009. */
/* Last updated by Enomoto Sanshiro on 8 May 2010. */


#include <string>
#include <iostream>
#include <vector>
#include "KinokoEventSorter.hh"
#include "KinokoSorterProcessor.hh"
#include "KinokoBuilder.hh"
#include "KinokoVerticalBuilder.hh"

using namespace std;


TKinokoVerticalBuilder::TKinokoVerticalBuilder(void)
{
    _EnvelopeReader = 0;
    _Sorter = 0;
}

TKinokoVerticalBuilder::~TKinokoVerticalBuilder()
{
    delete _EnvelopeReader;
    delete _Sorter;
}

void TKinokoVerticalBuilder::AddTargetDataSource(const std::string& DataSourceName, TStreamKey StreamKey)
{
    _InputDataSourceNameList.push_back(make_pair(DataSourceName, StreamKey));
}

TKinokoEventSorter& TKinokoVerticalBuilder::BuilderConstruct(void) throw(TKinokoException) 
{
    _Sorter = new TKinokoEventSegmentSorter(_EnvelopeWriter, _Buffer, _Arena);
    _Sorter->SetLogger(_Logger);

    _EnvelopeReader = new TKinokoEventEnvelopeReader(_Sorter);
    _EnvelopeReader->SetLogger(_Logger);

    for (unsigned i = 0; i < _InputDataSourceNameList.size(); i++) {
	_EnvelopeReader->AddTargetDataSource(
	    _InputDataSourceNameList[i].first,
	    _InputDataSourceNameList[i].second
	);
    }

    return _Sorter->Sorter();
}

void TKinokoVerticalBuilder::BuilderBegin(void) throw(TKinokoException)
{ 
    vector<pair<string, TStreamKey> > InputDataSourceNameList = (
	_EnvelopeReader->InputDataSourceNameList()
    );
    for (unsigned i = 0; i < InputDataSourceNameList.size(); i++) {
	TStreamKey StreamKey = InputDataSourceNameList[i].second; 
	_SorterController->RegisterStream(StreamKey);
    }
}

void TKinokoVerticalBuilder::BuilderEnd(void) throw(TKinokoException)
{ 
}

int TKinokoVerticalBuilder::BuilderProcess(void* Packet, long PacketSize) throw(TKinokoException)
{
    return _EnvelopeReader->ProcessPacket(Packet, PacketSize);
}
