/* KinokoVerticalBuilder.hh */
/* Created by Enomoto Sanshiro on 28 August 2009. */
/* Last updated by Enomoto Sanshiro on 8 May 2010. */


#ifndef __KinokoVerticalBuilder_hh__
#define __KinokoVerticalBuilder_hh__


#include <string>
#include <iostream>
#include <vector>
#include "KinokoEventSorter.hh"
#include "KinokoSorterProcessor.hh"
#include "KinokoBuilder.hh"


class TKinokoVerticalBuilder: public TKinokoBuilder {
  public:
    TKinokoVerticalBuilder(void);
    virtual ~TKinokoVerticalBuilder();
    virtual void AddTargetDataSource(const std::string& DataSourceName, TStreamKey StreamKey = -1);
  protected:
    // Builder Interface //
    virtual TKinokoEventSorter& BuilderConstruct(void) throw(TKinokoException);
    virtual void BuilderBegin(void) throw(TKinokoException);
    virtual void BuilderEnd(void) throw(TKinokoException);
    virtual int BuilderProcess(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    TKinokoEventSegmentSorter* _Sorter;
  protected:
    std::vector<std::pair<std::string, TStreamKey> > _InputDataSourceNameList;
    TKinokoEventEnvelopeReader* _EnvelopeReader;
};


#endif
