/* KinokoComponentPlatform.hh */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 24 June 2002. */


#ifndef __KinokoComponentPlatform_hh__
#define __KinokoComponentPlatform_hh__


#include <string>
#include <vector>
#include "KinokoPlatform.hh"
#include "KinokoComponent.hh"


class TKinokoComponentEventEmitter: public TKinokoEventEmitter {
  public:
    TKinokoComponentEventEmitter(TKinokoComponent* Component);
    virtual ~TKinokoComponentEventEmitter();
    virtual void EmitEvent(const std::string& EventName, const std::vector<std::string>& EventArgumentList) throw(TKinokoException);
    virtual bool EmitEventTo(const std::string& TargetName, const std::string& EventName, const std::vector<std::string>& EventArgumentList, std::string& ReturnValue) throw(TKinokoException);
  protected:
    TKinokoComponent* _Component;
};



class TKinokoComponentRegistry: public TKinokoRegistry {
  public:
    TKinokoComponentRegistry(TKcomRegistry* Registry);
    virtual ~TKinokoComponentRegistry();
    virtual std::string GetValue(const std::string& RegistryPath);
    virtual void SetValue(const std::string& RegistryPath, const std::string& Value);
    virtual long GetLongValue(const std::string& RegistryPath);
    virtual void SetLongValue(const std::string& RegistryPath, long Value);
  protected:
    TKcomRegistry* _Registry;
};



class TKinokoComponentTerminal: public TKinokoTerminal {
  public:
    TKinokoComponentTerminal(TKcomTerminal* Terminal);
    virtual ~TKinokoComponentTerminal();
    virtual int Put(const std::string& Line) throw(TKcomException);
    virtual int Get(std::string& Line, char Delimiter = '\n') throw(TKcomException);
    virtual void SetPrompt(const std::string& Prompt) throw(TKcomException);
  protected:
    TKcomTerminal* _Terminal;
};


#endif
