/* KinokoConsoleCom.cc */
/* Created by Enomoto Sanshiro on 22 August 2002. */
/* Last updated by Enomoto Sanshiro on 22 August 2002. */


#include <string>
#include <vector>
#include <iostream>
#include "KinokoComponentPlatform.hh"
#include "KinokoSystemComponent.hh"
#include "KinokoConsole.hh"
#include "KinokoConsoleCom.hh"

using namespace std;


static const string Comment = "Console: Kinoko System Controller";


TKinokoConsoleCom::TKinokoConsoleCom(void)
: TKinokoSystemComponent("KinokoConsoleCom")
{
    _EventEmitter = 0;
    _Registry = 0;
    _Terminal = 0;

    _Console = 0;
}

TKinokoConsoleCom::~TKinokoConsoleCom()
{
    delete _Console;

    delete _Terminal;
    delete _EventEmitter;
    delete _Registry;
}

void TKinokoConsoleCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoSystemComponent::BuildDescriptor(Descriptor);
    Descriptor.AddComment(Comment);

    TKcomEventDeclaration PrintEvent("print");
    PrintEvent.AddArgument(TKcomPropertyDeclaration(
        "message", TKcomPropertyDeclaration::Type_String
    ));
    Descriptor.RegisterEventSlot(EventId_Print, PrintEvent);

    TKcomEventDeclaration ExecuteEvent("execute");
    ExecuteEvent.AddArgument(TKcomPropertyDeclaration(
        "command_file_name", TKcomPropertyDeclaration::Type_String
    ));
    Descriptor.RegisterEventSlot(EventId_Execute, ExecuteEvent);
}

int TKinokoConsoleCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    int Result = 0;

    switch (EventId) {
      case EventId_Print:
	Result = ProcessPrintEvent(Event);
	break;

      case EventId_Execute:
	Result = ProcessExecuteEvent(Event, EventResponse);
	break;

      default:
	Result = TKinokoSystemComponent::ProcessEvent(
	    EventId, Event, EventResponse
	);
    }

    return Result;
}

void TKinokoConsoleCom::Initialize(void) throw(TKcomException)
{
    _EventEmitter = new TKinokoComponentEventEmitter(this);
    _Registry = new TKinokoComponentRegistry(Registry());

    if (Terminal() != 0) {
	_Terminal = new TKinokoComponentTerminal(Terminal());
	TKinokoThreadedConsole* ThreadedConsole = new TKinokoThreadedConsole(
	    InputStream(), OutputStream(), _EventEmitter, _Registry, _Terminal
	);
	ThreadedConsole->Start();
	_Console = ThreadedConsole;
    }
    else {
	_Terminal = new TKinokoNullTerminal();
	_Console = new TKinokoConsole(
	    InputStream(), OutputStream(), _EventEmitter, _Registry, _Terminal
	);
    }
}

void TKinokoConsoleCom::Finalize(void) throw(TKcomException)
{
    delete _Registry;
    delete _EventEmitter;
    delete _Terminal;

    _Registry = 0;
    _EventEmitter = 0;
    _Terminal = 0;

    if (_Console != 0) {
	_Console->Quit();
	delete _Console;
	_Console = 0;
    }
}

int TKinokoConsoleCom::DoTransaction(void) throw(TKcomException)
{
    TKinokoSystemComponent::DoTransaction();
    return 1;
}

int TKinokoConsoleCom::ProcessPrintEvent(TKcomEvent& Event)
{
    for (unsigned i = 0; i < Event.ArgumentList().size(); i++) {
	string Message = Event.ArgumentList()[i];
	_Console->Print(Message);
    }

    return 1;
}

int TKinokoConsoleCom::ProcessExecuteEvent(TKcomEvent& Event, TKcomEventResponse& Response)
{
    if (Event.ArgumentList().size() > 0) {
	string CommandFileName = Event.ArgumentList()[0];
	try {
	    _Console->Execute(CommandFileName);
	}
	catch (TScriptException &e) {
	    Response.IsError() = 1;
	    Response.ReturnValue() = "command execution error: " + e.Message();
	    cerr << "ERROR: " << e.Message() << endl;
	}
    }

    return 1;
}

void TKinokoConsoleCom::OnQuit(void) throw(TKcomException)
{
    _Console->Quit();
    TKinokoSystemComponent::OnQuit();
}
