/* KinokoControllerCom.hh */
/* Created by Enomoto Sanshiro on 7 December 2000. */
/* Last updated by Enomoto Sanshiro on 22 August 2002. */


#ifndef __KinokoControllerCom_hh__
#define __KinokoControllerCom_hh__


#include <string>
#include <vector>
#include "KinokoLoggerOrb.hh"
#include "KinokoComponentPlatform.hh"
#include "KinokoSystemComponent.hh"
#include "KinokoController.hh"


class TKinokoControllerCom: public TKinokoSystemComponent {
  public:
    TKinokoControllerCom(void);
    virtual ~TKinokoControllerCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual void Initialize(void) throw(TKcomException);
    virtual void Finalize(void) throw(TKcomException);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int DoTransaction(void) throw(TKcomException);
  protected:
    virtual int ProcessOpenEvent(TKcomEvent& Event);
    virtual int ProcessChangeStateEvent(TKcomEvent& Event);
    virtual int ProcessSetWidgetValueEvent(TKcomEvent& Event);
    virtual int ProcessSetWidgetAttributeEvent(TKcomEvent& Event);
    virtual int ProcessExecuteEvent(TKcomEvent& Event);
    virtual int ProcessOpenPopupEvent(TKcomEvent& Event);
    virtual int ProcessOpenQueryPopupEvent(TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int ProcessSaveEvent(TKcomEvent& Event);
    virtual int ProcessLoadEvent(TKcomEvent& Event);
    virtual int ProcessLoadScriptEvent(TKcomEvent& Event);
    virtual void OnQuit(void) throw(TKcomException);
  protected:
    enum TEventId {
	EventId_Open = TKinokoSystemComponent::_NumberOfEvents,
	EventId_ChangeState,
	EventId_Set,
	EventId_Execute,
	EventId_OpenPopup,
	EventId_OpenQueryPopup,
	EventId_Save,
	EventId_Load,
	EventId_LoadScript,
	EventId_SetWidgetValue,
	EventId_SetWidgetAttribute,
	_NumberOfEvents
    };
  protected:
    TKinokoLoggerProxy* _Logger;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
    TKinokoController* _Controller;
};


#endif
