/* KinokoDataFlowMeter.hh */
/* Created by Enomoto Sanshiro on 22 May 2001. */
/* Last updated by Enomoto Sanshiro on 22 May 2001. */


#ifndef __KinokoDataFlowMeter_hh__
#define __KinokoDataFlowMeter_hh__


#include "KinokoDataProcessor.hh"
#include "KinokoTaggedDataSection.hh"


class TKinokoDataFlowMeter: public TKinokoDataProcessor {
  public:
    TKinokoDataFlowMeter(void);
    virtual ~TKinokoDataFlowMeter();
  protected:
    virtual void BuildDataSource(TKinokoDataSource* DataSource);
    virtual void OnConstruct(void) throw(TKinokoException);
    virtual void OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual void OnReceiveDataPacket(void* Packet, long PacketSize) throw(TKinokoException);
    virtual void OnReceiveTrailerPacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    virtual void SendReportPacket(int EventRate, int DataFlow) throw(TKinokoException);
  protected:
    TKinokoTaggedDataSection* _DataSection;
    TKinokoTaggedDataSectionFormatter* _Formatter;
    long _EventCount, _DataAmount;
    int _EventRateIndex, _DataFlowIndex;
    int _LastReportTime, _ReportInterval;
};


#endif
