/* KinokoDataProcessorCom.hh */
/* Created by Enomoto Sanshiro on 23 April 2001. */
/* Last updated by Enomoto Sanshiro on 21 September 2004. */


#ifndef __KinokoDataProcessorCom_hh__
#define __KinokoDataProcessorCom_hh__


#include "KinokoDataProcessor.hh"
#include "KinokoStreamSourceComponent.hh"
#include "KinokoStreamPipeComponent.hh"
#include "KinokoStreamSinkComponent.hh"


class TKinokoDataProducerCom: public TKinokoStreamSourceComponent {
  public:
    TKinokoDataProducerCom(TKinokoDataProducer* DataProducer);
    virtual ~TKinokoDataProducerCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    TKinokoDataProducer* _DataProducer;
};


class TKinokoDataProcessorCom: public TKinokoStreamPipeComponent {
  public:
    TKinokoDataProcessorCom(TKinokoDataProcessor* DataProcessor);
    virtual ~TKinokoDataProcessorCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    TKinokoDataProcessor* _DataProcessor;
};


class TKinokoDataConsumerCom: public TKinokoStreamSinkComponent {
  public:
    TKinokoDataConsumerCom(TKinokoDataConsumer* DataConsumer);
    virtual ~TKinokoDataConsumerCom();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual void Construct(void) throw(TKinokoException);
    virtual void Destruct(void) throw(TKinokoException);
    virtual int ProcessData(void) throw(TKinokoException);
  protected:
    TKinokoDataConsumer* _DataConsumer;
};


#endif
