/* KinokoReporterCom.cc */
/* Created by Enomoto Sanshiro on 4 March 2002. */
/* Last updated by Enomoto Sanshiro on 4 March 2002. */


#include <string>
#include <vector>
#include <algorithm>
#include "MushFileSystem.hh"
#include "MushNetworkSocket.hh"
#include "MushMisc.hh"
#include "KinokoReporter.hh"
#include "KinokoReporterCom.hh"

using namespace std;


static const string Comment = "Reporter: Run Summary Generator";



TKinokoReporterCom::TKinokoReporterCom(void)
: TKinokoSystemComponent("KinokoReporterCom")
{
    _Reporter = new TKinokoReporter();
}

TKinokoReporterCom::~TKinokoReporterCom()
{
    delete _Reporter;
}

void TKinokoReporterCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoSystemComponent::BuildDescriptor(Descriptor);
    Descriptor.AddComment(Comment);

    TKcomEventDeclaration OpenEvent("open");
    OpenEvent.AddArgument(TKcomPropertyDeclaration(
        "file_name", TKcomPropertyDeclaration::Type_String
    ));
    Descriptor.RegisterEventSlot(EventId_Open, OpenEvent);

    TKcomEventDeclaration CloseEvent("close");
    Descriptor.RegisterEventSlot(EventId_Close, CloseEvent);

    TKcomEventDeclaration WriteEvent("write");
    WriteEvent.AddArgument(TKcomPropertyDeclaration(
        "name", TKcomPropertyDeclaration::Type_String
    ));
    WriteEvent.AddArgument(TKcomPropertyDeclaration(
        "contents", TKcomPropertyDeclaration::Type_String
    ));
    Descriptor.RegisterEventSlot(EventId_Write, WriteEvent);
}

int TKinokoReporterCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    int Result = 0;

    switch (EventId) {
      case EventId_Open:
	Result = ProcessOpenEvent(Event);
	break;

      case EventId_Close:
	Result = ProcessCloseEvent(Event);
	break;

      case EventId_Write:
	Result = ProcessWriteEvent(Event);
	break;

      case EventId_Quit:
	ProcessQuitEvent(Event);
	Result = TKinokoSystemComponent::ProcessEvent(
	    EventId, Event, EventResponse
	);
	break;

      default:
	Result = TKinokoSystemComponent::ProcessEvent(
	    EventId, Event, EventResponse
	);
    }

    return Result;
}

int TKinokoReporterCom::ProcessWriteEvent(TKcomEvent& Event)
{
    unsigned ArgumentIndex = 0;
    string Name, Contents;
    vector<pair<string, string> > AttributeList;

    if (Event.ArgumentList().size() == 0) {
	return 0;
    }
    Name = Event.ArgumentList()[ArgumentIndex++];

    if (Event.ArgumentList().size() > 1) {
	Contents = Event.ArgumentList()[ArgumentIndex++];
    }

    while (ArgumentIndex < Event.ArgumentList().size()) {
	string Attribute = Event.ArgumentList()[ArgumentIndex++];
	string::iterator NameEnd = find(Attribute.begin(), Attribute.end(), '=');
	if (NameEnd != Attribute.end()) {
	    string Name(Attribute.begin(), NameEnd);
	    string Value(NameEnd + 1, Attribute.end());
	    AttributeList.push_back(make_pair(Name, Value));
	}
    }

    _Reporter->Write(Name, Contents, AttributeList);

    return 1;
}

int TKinokoReporterCom::ProcessOpenEvent(TKcomEvent& Event)
{
    string ReportFileName;
    if (Event.ArgumentList().size() < 1) {
	ReportFileName = "kinoko-report.xml";
    }
    else {    
	ReportFileName = Event.ArgumentList()[0];
    }

    _Reporter->Open(ReportFileName);

    string Host = TMushNetworkSocket::LocalIPAddress();
    string Path = TMushFileAttribute(ReportFileName).PathName();
    string FileName = TMushFileAttribute(ReportFileName).FileName();
    if (Path.empty()) {
	Path = TMushFileSystem::CurrentDirectory() + "/";
    }
    Registry()->SetValue(
	"/files/report/" + ComponentName() + "/host", Host
    );
    Registry()->SetValue(
	"/files/report/" + ComponentName() + "/path", Path
    );
    Registry()->SetValue(
	"/files/report/" + ComponentName() + "/filename", FileName
    );

    return 1;
}

int TKinokoReporterCom::ProcessCloseEvent(TKcomEvent& Event)
{
    _Reporter->Close();
    return 1;
}

int TKinokoReporterCom::ProcessQuitEvent(TKcomEvent& Event)
{
    _Reporter->Close();
    return 1;
}
