/* KinokoStandalineBuilder.cc */
/* Edited by Enomoto Sanshiro on 28 August 2009. */
/* Last updated by Enomoto Sanshiro on 7 July 2010. */


#include <string>
#include <iostream>
#include "MushArgumentList.hh"
#include "KinokoHorizontalBuilder.hh"
#include "KinokoVerticalBuilder.hh"
#include "KinokoBuilderConfiguration.hh"
#include "KiscFancyConfigFile.hh"
#include "KinokoStandaloneComponent.hh"
#include "KinokoStandaloneBuilder.hh"

using namespace std;


TKinokoStandaloneBuilder::TKinokoStandaloneBuilder(int argc, char** argv)
: _ArgumentList(argc, argv)
{
}

TKinokoStandaloneBuilder::~TKinokoStandaloneBuilder()
{
}

int TKinokoStandaloneBuilder::Start(void) throw(TKinokoException)
{
    string ConfigFileName = _ArgumentList["--config"];
    string BuilderName = _ArgumentList["--name"];
    if ((_ArgumentList.NumberOfParameters() < 2) ||
	ConfigFileName.empty() || BuilderName.empty()
    ){
	cerr << "Usage: " << _ArgumentList.ProgramName();
	cerr << " --config=CONFIG_FILE_NAME --name=BUILDER_NAME";
	cerr << " INPUT_FILE OUTPUT_FILE" << endl;
	return -1;
    }       

    TKinokoBuilder* Builder = this->CreateBuilder();

    TKinokoBuilderOstreamLogger Logger(cout);
    TKinokoBuilderLoggingMonitor Monitor(&Logger);
    Builder->SetBuilderLogger(&Logger);
    Builder->SetBuilderMonitor(&Monitor);

    try {
	TKiscFancyConfigFile ConfigFile(ConfigFileName);
	ConfigFile.SetEntryKeyword("builder");
	TKinokoKiscBuilderConfiguration BuilderConfig(ConfigFile);
	BuilderConfig.ConfigureBuilder(Builder, BuilderName);
    }
    catch (TKinokoException& e) {
	delete Builder; Builder = 0; 
	throw TKinokoException(
	    "Builder configuration fault: " + e.Message()
	);
    }
    catch (TScriptException& e) {
	delete Builder; Builder = 0; 
	throw TKinokoException(
	    "Builder configuration fault: " + e.Message()
	);
    }
    
    TKinokoStandaloneDataProcessor Processor(Builder, BuilderName);
    Processor.Start(_ArgumentList);

    return 0;
}



TKinokoStandaloneHorizontalBuilder::TKinokoStandaloneHorizontalBuilder(int argc, char** argv)
: TKinokoStandaloneBuilder(argc, argv)
{
    _Scanner = 0;
}

TKinokoStandaloneHorizontalBuilder::~TKinokoStandaloneHorizontalBuilder()
{
}

void TKinokoStandaloneHorizontalBuilder::SetPieceScanner(TKinokoEventPieceScanner* Scanner)
{
    _Scanner = Scanner;
}

TKinokoBuilder* TKinokoStandaloneHorizontalBuilder::CreateBuilder(void) throw(TKinokoException)
{
    if (_Scanner == 0) {
	throw TKinokoException(
	    "TKinokoHorizontalBuilder: Event Piece Scanner not set"
	);
    }

    TKinokoHorizontalBuilder* Builder = new TKinokoHorizontalBuilder();
    Builder->SetPieceScanner(_Scanner);

    return Builder;
}



TKinokoStandaloneVerticalBuilder::TKinokoStandaloneVerticalBuilder(int argc, char** argv)
: TKinokoStandaloneBuilder(argc, argv)
{
}

TKinokoStandaloneVerticalBuilder::~TKinokoStandaloneVerticalBuilder()
{
}

TKinokoBuilder* TKinokoStandaloneVerticalBuilder::CreateBuilder(void) throw(TKinokoException)
{
    return new TKinokoVerticalBuilder();
}
