/* KinokoStreamPipeComponent.hh */
/* Created by Enomoto Sanshiro on 22 October 2000. */
/* Last updated by Enomoto Sanshiro on 22 October 2000. */


#ifndef __KinokoStreamPipeComponent_hh__
#define __KinokoStreamPipeComponent_hh__


#include <string>
#include "KinokoActiveStreamComponent.hh"


class TKinokoStreamPipeComponent: public TKinokoActiveStreamComponent {
  public:
    TKinokoStreamPipeComponent(const std::string& TypeName);
    virtual ~TKinokoStreamPipeComponent();
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
  protected:
    virtual int ProcessSetDataSourceNameEvent(TKcomEvent& Event) throw(TKinokoException);
    virtual int ProcessSetDataSourceIdEvent(TKcomEvent& Event) throw(TKinokoException);
    virtual void SetProperties(void) throw(TKinokoException);
  protected:
    virtual std::string DataSourceName(void);
    virtual int DataSourceId(void);
  protected:
    enum TEventId {
	EventId_SetDataSourceName = TKinokoActiveStreamComponent::_NumberOfEvents,
	EventId_SetDataSourceId,
	_NumberOfEvents
    };
  protected:
    std::string _SpecifiedDataSourceName;
    int _SpecifiedDataSourceId;
};


#endif
