/* KinokoStreamSourceComponent.cc */
/* Created by Enomoto Sanshiro on 11 October 2000. */
/* Last updated by Enomoto Sanshiro on 11 October 2000. */


#include <string>
#include <sstream>
#include "KinokoStreamSourceComponent.hh"

using namespace std;


TKinokoStreamSourceComponent::TKinokoStreamSourceComponent(const string& TypeName)
: TKinokoActiveStreamComponent(TypeName)
{
    _SpecifiedDataSourceId = 0;
}

TKinokoStreamSourceComponent::~TKinokoStreamSourceComponent()
{
}

void TKinokoStreamSourceComponent::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoActiveStreamComponent::BuildDescriptor(Descriptor);

    TKcomEventDeclaration StartEvent("start");
    Descriptor.RegisterEventSlot(EventId_Start, StartEvent);

    TKcomEventDeclaration StopEvent("stop");
    Descriptor.RegisterEventSlot(EventId_Stop, StopEvent);

    TKcomEventDeclaration SetDataSourceNameEvent("setDataSourceName");
    SetDataSourceNameEvent.AddArgument(TKcomPropertyDeclaration(
        "datasource_name", TKcomPropertyDeclaration::Type_String
    ));
    Descriptor.RegisterEventSlot(EventId_SetDataSourceName, SetDataSourceNameEvent);

    TKcomEventDeclaration SetDataSourceIdEvent("setDataSourceId");
    SetDataSourceNameEvent.AddArgument(TKcomPropertyDeclaration(
        "datasource_id", TKcomPropertyDeclaration::Type_Int
    ));
    Descriptor.RegisterEventSlot(EventId_SetDataSourceId, SetDataSourceIdEvent);
}

void TKinokoStreamSourceComponent::SetProperties(void) throw(TKinokoException)
{
    SetProperty(PropertyId_StreamType, _StreamTypeName[StreamType_Source]);
    SetProperty(PropertyId_Host, TMushNetworkSocket::LocalIPAddress());
    SetLongProperty(PropertyId_PortNumber, 0);
}

int TKinokoStreamSourceComponent::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    int Result = 0;

    try {
	switch (EventId) {
	  case EventId_Start:
	    Result = ProcessStartEvent(Event);
	    break;
	    
	  case EventId_Stop:
	    Result = ProcessStopEvent(Event);
	    break;
	
	case EventId_SetDataSourceName:
	    Result = ProcessSetDataSourceNameEvent(Event);
	    break;
	    
	case EventId_SetDataSourceId:
	    Result = ProcessSetDataSourceIdEvent(Event);
	    break;
	
	default:
	    Result = TKinokoActiveStreamComponent::ProcessEvent(
		EventId, Event, EventResponse
	    );
	}
    }
    catch (TKinokoException &e) {
	throw TKcomException(
	    "TKinokoStreamSourceComponent::ProcessEvent()",
	    "kinoko exception: " + e.Message()
	);
    }

    return Result;
}

int TKinokoStreamSourceComponent::ProcessStartEvent(TKcomEvent& Event) throw(TKinokoException)
{
    _Logger->WriteDebug(ComponentName(), "start()");
    StartDataProcessing();

    return 1;
}

int TKinokoStreamSourceComponent::ProcessStopEvent(TKcomEvent& Event) throw(TKinokoException)
{
    _Logger->WriteDebug(ComponentName(), "stop()");
    StopDataProcessing();

    return 1;
}

int TKinokoStreamSourceComponent::ProcessSetDataSourceNameEvent(TKcomEvent& Event) throw(TKinokoException)
{
    if (Event.ArgumentList().size() < 1) {
	_Logger->WriteError(
	    ComponentName(), "setDataSourceName(): too few arguments"
	);
	return 0;
    }

    _SpecifiedDataSourceName = Event.ArgumentList()[0];
    _Logger->WriteDebug(
	ComponentName(), "setDataSourceName(): " + _SpecifiedDataSourceName
    );

    return 1;
}

int TKinokoStreamSourceComponent::ProcessSetDataSourceIdEvent(TKcomEvent& Event) throw(TKinokoException)
{
    if (Event.ArgumentList().size() < 1) {
	_Logger->WriteError(
	    ComponentName(), "setDataSourceId(): too few arguments"
	);
	return 0;
    }

    string DataSourceIdString = Event.ArgumentList()[0];
    istringstream is(DataSourceIdString);
    if (! (is >> _SpecifiedDataSourceId)) {
	_Logger->WriteError(
	    ComponentName(), 
	    "setDataSourceId(): bad datasource_id: " + DataSourceIdString
	);
	return 0;
    }

    _Logger->WriteDebug(
	ComponentName(), "setDataSourceId(): " + DataSourceIdString
    );

    return 1;
}

string TKinokoStreamSourceComponent::DataSourceName(void)
{
    if (! _SpecifiedDataSourceName.empty()) {
	return _SpecifiedDataSourceName;
    }
    else {
	return ComponentName();
    }
}

int TKinokoStreamSourceComponent::DataSourceId(void)
{
    if (_SpecifiedDataSourceId != 0) {
	return _SpecifiedDataSourceId;
    }
    else {
	return AllocateDataSourceId();
    }
}
