/* KinokoSystemComponent.cc */
/* Created by Enomoto Sanshiro on 9 October 2000. */
/* Last updated by Enomoto Sanshiro on 9 October 2000. */


#include <string>
#include "KinokoComponent.hh"
#include "KinokoSystemComponent.hh"

using namespace std;


static const string Author = "Enomoto Sanshiro";
static const string Date = "22 January 2002";
static const int MajorVersion = 1;
static const int MinorVersion = 0;
static const string Comment = "Kinoko System Component";


TKinokoSystemComponent::TKinokoSystemComponent(const string& TypeName)
: TKinokoComponent(TypeName)
{
    _IsTerminateRequested = false;
}

TKinokoSystemComponent::~TKinokoSystemComponent()
{
}

void TKinokoSystemComponent::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoComponent::BuildDescriptor(Descriptor);

    Descriptor.SetAuthor(Author);
    Descriptor.SetDate(Date);
    Descriptor.SetVersion(MajorVersion, MinorVersion);
    Descriptor.AddComment(Comment);

    TKcomEventDeclaration QuitEvent("quit");
    Descriptor.RegisterEventSlot(EventId_Quit, QuitEvent);
}

void TKinokoSystemComponent::Initialize(void) throw(TKcomException)
{
}

void TKinokoSystemComponent::Finalize(void) throw(TKcomException)
{
}

int TKinokoSystemComponent::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    switch (EventId) {
      case EventId_Quit:
	OnQuit();
	_IsTerminateRequested = true;
	break;

      default:
	return TKinokoComponent::ProcessEvent(EventId, Event, EventResponse);
    }

    return 1;
}

void TKinokoSystemComponent::OnQuit(void) throw(TKcomException)
{
}

int TKinokoSystemComponent::DoTransaction(void) throw(TKcomException)
{
    if (_IsTerminateRequested) {
        Terminate();
	_IsTerminateRequested = false;
    }
    
    return TKinokoComponent::DoTransaction();
}
