/* KinokoTransporterCom.cc */
/* Created by Enomoto Sanshiro on 12 October 2000. */
/* Last updated by Enomoto Sanshiro on 12 October 2000. */


#include <string>
#include "KinokoDataProcessor.hh"
#include "KinokoTransporterCom.hh"

using namespace std;


static const string Comment = "Transporter: A Simple Data-Stream Connector";


TKinokoTransporterCom::TKinokoTransporterCom(void)
: TKinokoStreamPipeComponent("KinokoTransporterCom")
{
    _DataReceiver = 0;
}

TKinokoTransporterCom::~TKinokoTransporterCom()
{
    delete _DataReceiver;
}

void TKinokoTransporterCom::BuildDescriptor(TKcomComponentDescriptor& Descriptor)
{
    TKinokoStreamPipeComponent::BuildDescriptor(Descriptor);
    Descriptor.AddComment(Comment);
}

int TKinokoTransporterCom::ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse)
{
    return TKinokoStreamPipeComponent::ProcessEvent(EventId, Event, EventResponse);
}

void TKinokoTransporterCom::Construct(void) throw(TKinokoException)
{
    _DataReceiver = new TKinokoDataReceiver();
    _DataReceiver->SetStreamCommandProcessor(_StreamCommandProcessor);
    _DataReceiver->ConstructInlet(_InputDataStream);
}

void TKinokoTransporterCom::Destruct(void) throw(TKinokoException)
{
    delete _DataReceiver;
    _DataReceiver = 0;
}

int TKinokoTransporterCom::ProcessData(void)throw(TKinokoException)
{
    if (! _InputDataStream->HasData()) {
	_TimeKeeper->Suspend();
	return 0;
    }

    void* Data;
    int Size = _InputDataStream->NextEntry(Data);

    if (Size > 0) {
	_DataReceiver->ProcessDataDescriptorPacket(Data, Size);
	_DataReceiver->ProcessCommandPacket(Data, Size);

	int WrittenLength;
	while ((WrittenLength = _OutputDataStream->Write(Data, Size)) == 0) {
	    _Logger->WriteWarning(
		ComponentName(), "unable to write to stream"
	    );
	    _TimeKeeper->Suspend();
	}
	_InputDataStream->Flush(Data);

	if (WrittenLength != Size) {
	    throw TKinokoException(
		"TKinokoKdfRecorder::ProcessData()",
		"stream I/O error (internal)"
	    );
	}
    }

    return (Size > 0);
}
