/* KinokoControlInputWatcher.cc */
/* Created by Enomoto Sanshiro on 7 December 2000. */
/* Last updated by Enomoto Sanshiro on 22 August 2002. */


#include <iostream>
#include "MushMisc.hh"
#include "MushThread.hh"
#include "MushSignal.hh"
#include "KinokoControlInputWatcher.hh"

using namespace std;


TKinokoControlInputWatcher::TKinokoControlInputWatcher(istream& InputStream, char LineTerminator)
: _InputStream(InputStream), _LineTerminator(LineTerminator)
{
    _IsDataAvailable = false;
    _IsStopRequested = false;

    _DataAvailableCondition = new TMushThreadCondition();
    _DataProcessedCondition = new TMushThreadCondition();
}

TKinokoControlInputWatcher::~TKinokoControlInputWatcher()
{
    delete _DataProcessedCondition;
    delete _DataAvailableCondition;
}

void TKinokoControlInputWatcher::Run(void)
{
    //... very temporary ...//
    sigset_t sigset;
    sigfillset(&sigset);
    pthread_sigmask(SIG_BLOCK, &sigset, NULL);

    while ((! _IsStopRequested) && (! _InputStream.eof())) {
	getline(_InputStream, _Line, _LineTerminator);

	_DataAvailableCondition->Lock();
	_IsDataAvailable = true;
	_DataAvailableCondition->Signal();
	_DataAvailableCondition->Unlock();

	_DataProcessedCondition->Lock();
	while (_IsDataAvailable && (! _IsStopRequested)) {
	    _DataProcessedCondition->Wait();
	} 
	_DataProcessedCondition->Unlock();

	_InputStream >> ws;
    }
}

void TKinokoControlInputWatcher::Stop(void)
{
    _IsStopRequested = true;
    _DataProcessedCondition->Signal();
}

bool TKinokoControlInputWatcher::IsDataAvailable(void)
{
    return _IsDataAvailable;
}

bool TKinokoControlInputWatcher::WaitData(long TimeOut_Sec)
{
    _DataAvailableCondition->Lock();

    if (! _IsDataAvailable) {
	if (TimeOut_Sec > 0) {
	    TimeOut_Sec += TMushDateTime::SecSinceEpoch();
	    _DataAvailableCondition->TimedWait(TimeOut_Sec);
	}
	else {
	    _DataAvailableCondition->Wait();
	}
    }

    _DataAvailableCondition->Unlock();

    return _IsDataAvailable;
}

const string& TKinokoControlInputWatcher::Line(void)
{
    return _Line;
}

void TKinokoControlInputWatcher::Flush(void)
{
    _DataProcessedCondition->Lock();

    _IsDataAvailable = false;
    _DataProcessedCondition->Signal();

    _DataProcessedCondition->Unlock();
}
