/* KinokoControlScript.hh */
/* Created by Enomoto Sanshiro on 22 August 2002. */
/* Last updated by Enomoto Sanshiro on 22 August 2002. */


#ifndef __KinokoControlScript_hh__
#define __KinokoControlScript_hh__


#include <string>
#include <vector>
#include "KiscScript.hh"
#include "KinokoPlatform.hh"


class TKinokoControlScript: public TKiscScript {
  public:
    TKinokoControlScript(TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry);
    virtual ~TKinokoControlScript();
  protected:
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
    virtual TParaBuiltinFunctionTable* CreateBuiltinFunctionTable(void);
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaOperatorTable* CreateOperatorTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
    virtual TParaPackage* CreatePackage(void);
  protected:
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
};


class TKinokoControlSystemMessenger: public TParaObjectPrototype {
  public:
    TKinokoControlSystemMessenger(TKinokoRegistry* Registry);
    virtual ~TKinokoControlSystemMessenger();
    virtual TParaObjectPrototype* Clone(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_GetRegistry = TParaObjectPrototype::_NumberOfMethods,
	MethodId_SetRegistry,
	_NumberOfMethods
    };
  protected:
    virtual int GetRegistry(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
    virtual int SetRegistry(std::vector<TParaValue*>& ArgumentList, TParaValue& Result) throw(TScriptException);
  protected:
    TKinokoRegistry* _Registry;
};


class TKinokoControlScriptInvokeStatement: public TParaStatement {
  public:
    TKinokoControlScriptInvokeStatement(TKinokoEventEmitter* EventEmitter);
    virtual ~TKinokoControlScriptInvokeStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoEventEmitter* _EventEmitter;
    std::string _TargetName;
    std::string _EventName;
    std::vector<TParaExpression*> _ArgumentExpressionList;
};


#endif
