/* KinokoDefs.hh */
/* Created by Enomoto Sanshiro on 17 November 1997. */
/* Last updated by Enomoto Sanshiro on 1 February 2000. */


#ifndef __KinokoDefs_hh__
#define __KinokoDefs_hh__


#include <iostream>
#include <fstream>
#include <string>
#include <cstring>
#include "RoomDefs.hh"
#include "MushDefs.hh"
#include "ParaDefs.hh"
#include "MushMisc.hh"
#include "KinokoConfig.hh"


enum TKinokoResult {
    KinokoSuccess = 0,
    KinokoFailure = -1
};


class TKinokoException {
  protected:
    std::string _Message;
  public:
    TKinokoException(std::string Location, std::string Message);
    TKinokoException(std::string Message);
    TKinokoException(const TKinokoException &e);
    std::string Message(void) const;
    friend std::ostream& operator<< (std::ostream &os, const TKinokoException &e);
};

#if 1
#define kerr (std::ofstream(".kinoko-errors", ios::app) << TMushDateTime().AsStringn() << " ")
#else
#define kerr cerr
#endif

#endif
