/* KinokoPlatform.cc */
/* Created by Enomoto Sanshiro on 8 July 2001. */
/* Last updated by Enomoto Sanshiro on 18 July 2002. */


#include <iostream>
#include <string>
#include "KinokoPlatform.hh"

using namespace std;


TKinokoEventEmitter::TKinokoEventEmitter(void)
{
}

TKinokoEventEmitter::~TKinokoEventEmitter()
{
}

void TKinokoEventEmitter::EmitEvent(const string& EventName, const vector<string>& EventArgumentList) throw(TKinokoException)
{
    cout << EventName << ": ";
    for (unsigned i = 0; i < EventArgumentList.size(); i++) {
	cout << "\"" << EventArgumentList[i] << "\" ";
    }
    cout << endl;
}

bool TKinokoEventEmitter::EmitEventTo(const string& TargetName, const string& EventName, const vector<string>& EventArgumentList, string& ReturnValue) throw(TKinokoException)
{
    cout << TargetName << "." << EventName << ": ";
    for (unsigned i = 0; i < EventArgumentList.size(); i++) {
	cout << "\"" << EventArgumentList[i] << "\" ";
    }
    cout << endl;

    return true;
}



TKinokoRegistry::TKinokoRegistry(void)
{
}

TKinokoRegistry::~TKinokoRegistry()
{
}



TKinokoNullRegistry::TKinokoNullRegistry(void)
{
}

TKinokoNullRegistry::~TKinokoNullRegistry()
{
}

string TKinokoNullRegistry::GetValue(const string& RegistryPath)
{
    return string();
}

long TKinokoNullRegistry::GetLongValue(const string& RegistryPath)
{
    return 0;
}

void TKinokoNullRegistry::SetValue(const string& RegistryPath, const string& Value)
{
}

void TKinokoNullRegistry::SetLongValue(const string& RegistryPath, long Value)
{
}



TKinokoTerminal::TKinokoTerminal(void)
{
}

TKinokoTerminal::~TKinokoTerminal()
{
}



TKinokoNullTerminal::TKinokoNullTerminal(void)
{
}

TKinokoNullTerminal::~TKinokoNullTerminal()
{
}

int TKinokoNullTerminal::Put(const string& Line) throw(TKcomException)
{
    return 0;
}

int TKinokoNullTerminal::Get(string& Line, char Delimiter) throw(TKcomException)
{
    return 0;
}

void TKinokoNullTerminal::SetPrompt(const string& Prompt) throw(TKcomException)
{
}
