/* KinokoBlockDataSection.hh */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 19 November 2000. */


#ifndef __KinokoBlockDataSection_hh__
#define __KinokoBlockDataSection_hh__


#include <iostream>
#include <string>
#include "ParaTokenizer.hh"
#include "KinokoDataSection.hh"


class TKinokoBlockDataSectionFormatter;
class TKinokoBlockDataSectionScanner;


class TKinokoBlockDataSection: public TKinokoDataSection {
  public:
    TKinokoBlockDataSection(TKinokoDataSource* DataSource, const std::string& SectionName);
    TKinokoBlockDataSection(TKinokoDataSource* DataSource, const std::string& SectionName, int SectionId);
    virtual ~TKinokoBlockDataSection();
    virtual int SectionType(void) const;
    virtual void ReadFrom(TParaTokenizer& Tokenizer) throw(TKinokoException);
    virtual void WriteTo(std::ostream& os, const std::string& Indent);
    inline TKinokoBlockDataSectionFormatter* Formatter(void);
    inline TKinokoBlockDataSectionScanner* Scanner(void);
  protected:
    TKinokoBlockDataSectionFormatter* _Formatter;
    TKinokoBlockDataSectionScanner* _Scanner;
};


class TKinokoBlockDataSectionFormatter: public TKinokoDataSectionFormatter {
  public:
    TKinokoBlockDataSectionFormatter(TKinokoBlockDataSection* DataSection);
    virtual ~TKinokoBlockDataSectionFormatter();
};


class TKinokoBlockDataSectionScanner: public TKinokoDataSectionScanner {
  public:
    TKinokoBlockDataSectionScanner(TKinokoBlockDataSection* DataSection);
    virtual ~TKinokoBlockDataSectionScanner();
};



inline TKinokoBlockDataSectionFormatter* TKinokoBlockDataSection::Formatter(void)
{
    if (_Formatter == 0) {
	_Formatter = new TKinokoBlockDataSectionFormatter(this);
    }

    return _Formatter;
}

inline TKinokoBlockDataSectionScanner* TKinokoBlockDataSection::Scanner(void)
{
    if (_Scanner == 0) {
	_Scanner = new TKinokoBlockDataSectionScanner(this);
    }

    return _Scanner;
}


#endif
