/* KinokoDataDescriptor.hh */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 19 November 2000. */


#ifndef __KinokoDataDescriptor_hh__
#define __KinokoDataDescriptor_hh__


#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "KinokoDataSource.hh"


class TKinokoDataDescriptor {
  public:
    TKinokoDataDescriptor(void);
    virtual ~TKinokoDataDescriptor();
    virtual void AddDataSource(TKinokoDataSource* DataSource);
    virtual TKinokoDataSource* DataSource(long DataSourceId);
    virtual TKinokoDataSource* DataSource(const std::string& DataSourceName);
    virtual const std::vector<TKinokoDataSource*>& DataSourceList(void);
    virtual void ReadFrom(std::istream& is) throw(TKinokoException);
    virtual void WriteTo(std::ostream& os);
  protected:
    std::vector<TKinokoDataSource*> _DataSourceList;
    std::map<long, TKinokoDataSource*> _DataSourceTable;
    std::map<std::string, TKinokoDataSource*> _DataSourceNameTable;
};


#endif
