/* KinokoNestedDataSection.hh */
/* Created by Enomoto Sanshiro on 19 November 2000. */
/* Last updated by Enomoto Sanshiro on 25 January 2002. */


#ifndef __KinokoNestedDataSection_hh__
#define __KinokoNestedDataSection_hh__

#include <iostream>
#include <string>
#include <vector>
#include <map>
#include "ParaTokenizer.hh"
#include "KinokoDataSection.hh"
#include "KinokoDataSectionContainer.hh"


class TKinokoNestedDataSectionFormatter;
class TKinokoNestedDataSectionScanner;


class TKinokoNestedDataSection: public TKinokoDataSection, public TKinokoDataSectionContainer {
  public:
    TKinokoNestedDataSection(TKinokoDataSource* DataSource, const std::string& SectionName);
    TKinokoNestedDataSection(TKinokoDataSource* DataSource, const std::string& SectionName, int SectionId);
    virtual ~TKinokoNestedDataSection();
    virtual void AddDataSection(TKinokoDataSection* DataSection);
    virtual int SectionType(void) const;
    virtual void ReadFrom(TParaTokenizer& Tokenizer) throw(TKinokoException);
    virtual void WriteTo(std::ostream& os, const std::string& Indent);
    inline TKinokoNestedDataSectionFormatter* Formatter(void);
    inline TKinokoNestedDataSectionScanner* Scanner(void);
  protected:
    TKinokoNestedDataSectionFormatter* _Formatter;
    TKinokoNestedDataSectionScanner* _Scanner;
};


class TKinokoNestedDataSectionFormatter: public TKinokoDataSectionFormatter {
  public:
    TKinokoNestedDataSectionFormatter(TKinokoNestedDataSection* DataSection);
    virtual ~TKinokoNestedDataSectionFormatter();
};


class TKinokoNestedDataSectionScanner: public TKinokoDataSectionScanner {
  public:
    TKinokoNestedDataSectionScanner(TKinokoNestedDataSection* DataSection);
    virtual ~TKinokoNestedDataSectionScanner();
};



inline TKinokoNestedDataSectionFormatter* TKinokoNestedDataSection::Formatter(void)
{
    if (_Formatter == 0) {
	_Formatter = new TKinokoNestedDataSectionFormatter(this);
    }

    return _Formatter;
}

inline TKinokoNestedDataSectionScanner* TKinokoNestedDataSection::Scanner(void)
{
    if (_Scanner == 0) {
	_Scanner = new TKinokoNestedDataSectionScanner(this);
    }

    return _Scanner;
}


#endif
