/* KinokoDaqBuilder.hh */
/* Created by Enomoto Sanshiro on 9 October 1999. */
/* Last updated by Enomoto Sanshiro on 8 July 2001. */


#ifndef __KinokoDaqBuilder_hh__
#define __KinokoDaqBuilder_hh__


#include <string>
#include <deque>
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoDevicePool.hh"
#include "KinokoTrigger.hh"
#include "KinokoTransaction.hh"
#include "KinokoDataRecord.hh"
#include "KinokoPlatform.hh"
#include "KinokoStream.hh"


class TKinokoDaqBuilder {
  public:
    TKinokoDaqBuilder(const std::string& DataSourceName, int DataSourceId, TKinokoOutputStream* OutStream, TKinokoEventEmitter* EventEmitter, TKinokoRegistry* Registry);
    virtual ~TKinokoDaqBuilder();
    virtual void Construct(void) throw(TKinokoException) = 0;
    virtual void Destruct(void) throw(TKinokoException);
    virtual TKinokoDevicePool* DevicePool(void) throw(TKinokoException);
    virtual TKinokoTransaction* Transaction(void) throw(TKinokoException);
    virtual TKinokoTrigger* Trigger(void) throw(TKinokoException);
    virtual TKinokoDataSource* DataSource(void);
  public:
    virtual void RegisterDataSourceName(const std::string& Name, int DataSourceId = 0);
    virtual int RegisterCrate(const std::string& Name, TRoomCrate* Crate);
    virtual int RegisterController(const std::string& Name, TRoomController* Controller);
    virtual int RegisterModule(const std::string& Name, TRoomModule* Module);
    virtual int RegisterReadoutUnit(const std::string& UnitName);
    virtual int RegisterRegister(const std::string& RegisterName, int* Register);
    virtual int RegisterDataRecord(const std::string& DataRecordName, TKinokoDataRecord* DataRecord);
    virtual void OpenReadoutSequence(int TriggerSourceId, int* TriggerIdRegister = 0);
    virtual void OpenReadoutSequence(const std::string& EventName, std::vector<int*> ArgumentRegisterList);
    virtual void CloseReadoutSequence(void);
    virtual void OpenConditionalReadoutSequence(TKinokoReadoutCondition* Condition);
    virtual void CloseConditionalReadoutSequence(void);
    virtual void OpenReadoutUnit(TKinokoUnitedReadoutActions* UnitedReadoutActions, TKinokoNestedDataSection* DataSection) throw(TKinokoException);
    virtual void CloseReadoutUnit(void);
    virtual void AddReadoutAction(TKinokoReadoutAction* ReadoutAction, TKinokoDataSection* DataSection = 0) throw(TKinokoException);
    virtual unsigned AddTriggerSource(const std::string& TriggerSourceName) throw(TKinokoException);
    virtual void AddAttribute(const std::string& Name, const std::string& Value) throw(TKinokoException);
    virtual TKinokoEventEmitter* EventEmitter(void);
    virtual TKinokoRegistry* Registry(void);
    virtual int HashValueOf(const std::string& String);
  protected:
    TKinokoDataSource* _DataSource; 
    TKinokoDevicePool* _DevicePool;
    TKinokoTrigger* _Trigger;
    TKinokoTransaction* _Transaction;
    TKinokoEventEmitter* _EventEmitter;
    TKinokoRegistry* _Registry;
    std::deque<TKinokoReadoutSequence*> _ReadoutSequenceStack;
    std::deque<TKinokoNestedDataSection*> _NestedDataSectionStack;
    std::vector<std::pair<std::string, int> > _DataSourceNameList;
    bool _IsConstructed;
};


#endif
