/* KinokoDaqScriptStatement.hh */
/* Created by Enomoto Sanshiro on 11 October 1999. */
/* Last updated by Enomoto Sanshiro on 6 July 2001. */


#ifndef __KinokoDaqScriptStatement_hh__
#define __KinokoDaqScriptStatement_hh__


#include <string>
#include <vector>
#include <map>
#include "ParaPackage.hh"
#include "ParaStatement.hh"
#include "ParaExpression.hh"
#include "ParaOperator.hh"
#include "KinokoDaqBuilder.hh"



class TKinokoDaqScriptOnStatement: public TParaStatement {
  public:
    TKinokoDaqScriptOnStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptOnStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    TKinokoDaqScriptOnStatement* _ConcreteStatement;
};


class TKinokoDaqScriptOnTriggerStatement: public TKinokoDaqScriptOnStatement {
  public:
    TKinokoDaqScriptOnTriggerStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptOnTriggerStatement();
    virtual TParaStatement* Clone(void);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TParaExpression* _ModuleExpression;
    TParaExpression* _RegisterExpression;
    TParaStatement* _Statement;
};


class TKinokoDaqScriptOnCommandStatement: public TKinokoDaqScriptOnStatement {
  public:
    TKinokoDaqScriptOnCommandStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptOnCommandStatement();
    virtual TParaStatement* Clone(void);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    std::string _CommandName;
    std::vector<TParaExpression*> _RegisterExpressionList;
    TParaStatement* _Statement;
};


class TKinokoDaqScriptOnTrapStatement: public TKinokoDaqScriptOnStatement {
  public:
    TKinokoDaqScriptOnTrapStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptOnTrapStatement();
    virtual TParaStatement* Clone(void);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    long _TrapId;
    TParaStatement* _Statement;
};


class TKinokoDaqScriptTerminateStatement: public TParaStatement {
  public:
    TKinokoDaqScriptTerminateStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptTerminateStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
};


class TKinokoDaqScriptSkipStatement: public TParaStatement {
  public:
    TKinokoDaqScriptSkipStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptSkipStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
};


class TKinokoDaqScriptInvokeStatement: public TParaStatement {
  public:
    TKinokoDaqScriptInvokeStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptInvokeStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _EventName;
    std::vector<TParaExpression*> _EventArgumentExpressionList;
};


class TKinokoDaqScriptWhenStatement: public TParaStatement {
  public:
    TKinokoDaqScriptWhenStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptWhenStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    TParaExpression* _ConditionExpression;
    TParaStatement* _Statement;
};


class TKinokoDaqScriptUnitStatement: public TParaStatement {
  public:
    TKinokoDaqScriptUnitStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptUnitStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _UnitName;
    int _SectionId;
    TParaStatement* _Statement;
};


class TKinokoDaqScriptAttributeStatement: public TParaStatement {
  public:
    TKinokoDaqScriptAttributeStatement(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptAttributeStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    std::string _Name;
    TParaExpression* _ValueExpression;
};


class TKinokoDaqScriptDataSourceEntry: public TParaPackageEntry {
  public:
    TKinokoDaqScriptDataSourceEntry(TKinokoDaqBuilder* DaqBuilder);
    virtual ~TKinokoDaqScriptDataSourceEntry();
    virtual TParaPackageEntry* Clone(void);
    virtual bool HasEntryWordsOf(TParaTokenizer* Tokenizer);
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TParaValue Execute(const std::vector<TParaValue*>& ArgumentList, TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKinokoDaqBuilder* _DaqBuilder;
    TParaStatement* _Statement;
};


#endif
