/* KinokoDataRecord.hh */
/* Created by Enomoto Sanshiro on 20 July 2001. */
/* Last updated by Enomoto Sanshiro on 20 July 2001. */


#ifndef __KinokoDataRecord_hh__
#define __KinokoDataRecord_hh__


#include <iostream>
#include <string>
#include "KinokoTaggedDataSection.hh"


class TKinokoDataRecord {
  public:
    TKinokoDataRecord(TKinokoTaggedDataSection* DataSection);
    virtual ~TKinokoDataRecord();
    virtual int AddField(const std::string& FieldName, int Width, int FieldValueType, const std::string& PrintFormat = "");
    virtual void AddFieldValueAlias(int FieldIndex, int Value, const std::string& Name);
    virtual void Initialize(void);
    virtual void FillField(int Index, int Value);
    virtual void Clear(void);
    virtual int PacketSize(void);
    virtual int WriteTo(void* Buffer);
    virtual const std::string& Name(void);
    virtual void Dump(std::ostream& os);
  protected:
    TKinokoTaggedDataSection* _DataSection;
    TKinokoTaggedDataSectionFormatter* _Formatter;
    int* _DataArea;
    int _NumberOfFields;
    int _DataAreaSize, _PacketSize;
};


#endif
