/* KinokoMetaReadoutAction.hh */
/* Created by Enomoto Sanshiro on 4 July 2001. */
/* Last updated by Enomoto Sanshiro on 9 March 2003. */


#ifndef __KinokoMetaReadoutAction_hh__
#define __KinokoMetaReadoutAction_hh__


#include <string>
#include <vector>
#include "KcomRegistry.hh"
#include "KinokoReadoutAction.hh"
#include "KinokoPlatform.hh"
#include "KinokoDataRecord.hh"

class TKinokoTrigger;


class TKinokoRegisterAction: public TKinokoReadoutAction {
  public:
    TKinokoRegisterAction(int* Register, int OperationId, int* ParameterRegister);
    virtual ~TKinokoRegisterAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  public:
    enum TOperationId {
	OperationId_Load,
	OperationId_Add,
	OperationId_Subtract,
	OperationId_Multiply,
	OperationId_Divide,
	OperationId_Modulo,
	OperationId_And,
	OperationId_Or,
	OperationId_Xor,
	OperationId_ShiftLeft,
	OperationId_ShiftRight,
	_NumberOfOperations
    };
  protected:
    int* _Register;
    int _OperationId;
    int* _ParameterRegister;
};


class TKinokoRegisterDumpAction: public TKinokoReadoutAction {
  public:
    TKinokoRegisterDumpAction(int* Register, const std::string& Name);
    virtual ~TKinokoRegisterDumpAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    int* _Register;
    std::string _Name;
};


class TKinokoDataRecordFillAction: public TKinokoReadoutAction {
  public:
    TKinokoDataRecordFillAction(TKinokoDataRecord* DataRecord, int Index, int* Register);
    virtual ~TKinokoDataRecordFillAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoDataRecord* _DataRecord;
    int _Index;
    int* _Register;
    int _ValueWidth;
};


class TKinokoDataRecordSendAction: public TKinokoReadoutAction {
  public:
    TKinokoDataRecordSendAction(TKinokoDataRecord* DataRecord);
    virtual ~TKinokoDataRecordSendAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoDataRecord* _DataRecord;
};


class TKinokoDataRecordDumpAction: public TKinokoReadoutAction {
  public:
    TKinokoDataRecordDumpAction(TKinokoDataRecord* DataRecord);
    virtual ~TKinokoDataRecordDumpAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoDataRecord* _DataRecord;
};


class TKinokoDaqInvokeAction: public TKinokoReadoutAction {
  public:
    TKinokoDaqInvokeAction(TKinokoEventEmitter* EventEmitter, const std::string& EventName, const std::vector<std::string>& EventArgumentList);
    virtual ~TKinokoDaqInvokeAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoEventEmitter* _EventEmitter;
    std::string _EventName;
    std::vector<std::string> _EventArgumentList;
};


class TKinokoReadRegistryAction: public TKinokoReadoutAction {
  public:
    TKinokoReadRegistryAction(TKinokoRegistry* Registry, const std::string& RegistryPath, int* Register);
    virtual ~TKinokoReadRegistryAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoRegistry* _Registry;
    std::string _RegistryPath;
    int* _Register;
};


class TKinokoWriteRegistryAction: public TKinokoReadoutAction {
  public:
    TKinokoWriteRegistryAction(TKinokoRegistry* Registry, const std::string& RegistryPath, int* Register);
    virtual ~TKinokoWriteRegistryAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoRegistry* _Registry;
    std::string _RegistryPath;
    int* _Register;
};


class TKinokoReadTimeAction: public TKinokoReadoutAction {
  public:
    TKinokoReadTimeAction(int* SecRegister, int* USecRegister);
    virtual ~TKinokoReadTimeAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    int* _SecRegister, _DummySecRegister;
    int* _USecRegister, _DummyUSecRegister;
};


class TKinokoTerminateAction: public TKinokoReadoutAction {
  public:
    TKinokoTerminateAction(TKinokoTrigger* Trigger);
    virtual ~TKinokoTerminateAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    TKinokoTrigger* _Trigger;
};


class TKinokoSkipAction: public TKinokoReadoutAction {
  public:
    TKinokoSkipAction(void);
    virtual ~TKinokoSkipAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
};


class TKinokoSuspendAction: public TKinokoReadoutAction {
  public:
    TKinokoSuspendAction(int Time_sec, int Time_usec);
    virtual ~TKinokoSuspendAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    int _Time_sec, _Time_usec;
};


class TKinokoEchoAction: public TKinokoReadoutAction {
  public:
    TKinokoEchoAction(const std::string& Message, int* Register, int Base=10);
    virtual ~TKinokoEchoAction();
    virtual void Initialize(void);
    virtual int NextPacketSize(void);
    virtual int GoNext(void* DataBuffer, int& StatusFlag) throw(TKinokoException);
    virtual void Dump(std::ostream& os, const std::string& Indent = "");
  protected:
    std::string _Message;
    int* _Register;
    int _Base;
};


#endif
