/* KinokoTrigger.cc */
/* Created by Enomoto Sanshiro on 16 April 1999. */
/* Last updated by Enomoto Sanshiro on 29 March 2002. */


#include "MushTimer.hh"
#include "RoomServiceRequester.hh"
#include "RoomModule.hh"
#include "KinokoDefs.hh"
#include "KinokoTrigger.hh"

using namespace std;


TKinokoTrigger::TKinokoTrigger(void)
{
    _RequestHandler = 0;
    _PollingInterval = -1;
    _IsPollingForced = false;
}

TKinokoTrigger::~TKinokoTrigger() 
{
    delete _RequestHandler;
}

void TKinokoTrigger::AddTriggerSource(int TriggerSourceId, TRoomModule* TriggerSource)
{
    _TriggerSourceList.push_back(make_pair(TriggerSourceId, TriggerSource));
}

void TKinokoTrigger::SetPollingInterval(int Interval_usec)
{
    if (Interval_usec < 0) {
	Interval_usec = 0;
    }

    _PollingInterval = Interval_usec;

    if (_RequestHandler) {
	_RequestHandler->SetPollingInterval(_PollingInterval);
    }
}

void TKinokoTrigger::ForcePolling(void)
{
    _IsPollingForced = true;
    if (_RequestHandler) {
	_RequestHandler->ForcePolling();
    }
}

void TKinokoTrigger::Initialize(void)  throw(TKinokoException)
{
    try {
	_RequestHandler = new TRoomServiceRequestHandler();

	if (_PollingInterval >= 0) {
	    _RequestHandler->SetPollingInterval(_PollingInterval);
	    if (_IsPollingForced) {
		_RequestHandler->ForcePolling();
	    }
	}

	for (unsigned i = 0; i < _TriggerSourceList.size(); i++) {
	    int TriggerSourceId = _TriggerSourceList[i].first;
	    TRoomModule* TriggerSource = _TriggerSourceList[i].second;
	    _RequestHandler->RegisterRequester(TriggerSource, TriggerSourceId);
	}

	_RequestHandler->Initialize();
    }
    catch (THardwareException &e) {
	throw TKinokoException(
	    "TKinokoTrigger::Initlalize()",
	    "hardware exception: " + e.Message()
	);
    }

    _IsStopRequested = false;
}

void TKinokoTrigger::Finalize(void)  throw(TKinokoException)
{
    try {
	_RequestHandler->Finalize();
    }
    catch (THardwareException &e) {
	throw TKinokoException(
	    "TKinokoTrigger::Finalize()", 
	    "hardware exception: " + e.Message()
	);
    }

    delete _RequestHandler;
    _RequestHandler = 0;
}

bool TKinokoTrigger::Wait(int& TriggerSourceId, int& TriggerId) throw(TKinokoException)
{
    try {
	if (_IsStopRequested) {
	    return false;
	}
	else {
	    return _RequestHandler->WaitForServiceRequest(
		TriggerSourceId, TriggerId
	    );
	}
    }
    catch (THardwareException &e) {
	throw TKinokoException(
	    "TKinokoTrigger::Wait()", "hardware exception: " + e.Message()
	);
    }
}

void TKinokoTrigger::Clear(void) throw(TKinokoException)
{
    try {
	_RequestHandler->ClearServiceRequest();
    }
    catch (THardwareException &e) {
	throw TKinokoException(
	    "TKinokoTrigger::Clear()", "hardware exception: " + e.Message()
	);
    }
}

void TKinokoTrigger::Stop(void)
{
    _IsStopRequested = true;
}

bool TKinokoTrigger::IsStopRequested(void)
{
    return _IsStopRequested;
}
