/* KinokoKdfRecorder.hh */
/* Created by Enomoto Sanshiro on 12 October 2000. */
/* Last updated by Enomoto Sanshiro on 6 October 2002. */


#ifndef __KinokoKdfRecorder_hh__
#define __KinokoKdfRecorder_hh__


#include <string>
#include "MushTimer.hh"
#include "KinokoFileStream.hh"
#include "KinokoNullStream.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoStorage.hh"
#include "KinokoRecorder.hh"
#include "KinokoKdfStorage.hh"



class TKinokoKdfRecorder: public TKinokoRecorder {
  public:
    TKinokoKdfRecorder(bool IsRawKdf = false);
    virtual ~TKinokoKdfRecorder();
    virtual void SetDataFile(const std::string& FileName);
    virtual void AllowOverWrite(void);
    virtual void SetDataFileAccessMode(int AccessMode);
    virtual void SetMaxSubfileSize(long SubfileSize);
    virtual void EnableDataCompression(void);
    virtual void EnableIndex(void);
    virtual void AddHeaderEntry(const std::string& Name, const std::string& Value);
    virtual void ImportHeaderFrom(const std::string& FileName);
    virtual void OnConstruct(void) throw(TKinokoException);
    virtual void OnDestruct(void) throw(TKinokoException);
    virtual void OnReceivePacket(void* Packet, long PacketSize) throw(TKinokoException);
  protected:
    std::string _FileName;
    TKinokoKdfStorage* _Storage;
    TKinokoStorageHeader* _StorageHeader;
    TKinokoOutputStream* _OutputStream;
    TKinokoOutputStream* _OutputNullStream;
    bool _IsRawKdf;
    bool _IsOverWriteAllowed;
    int _AccessMode;
    bool _IsDataCompressionEnabled;
    bool _IsIndexEnabled;
    long _MaxSubfileSize;
};


#endif
