/* KinokoStorageHeader.hh */
/* Created by Enomoto Sanshiro on 9 January 2000. */
/* Last updated by Enomoto Sanshiro on 23 January 2000. */


#ifndef __KinokoStorageHeader_hh__
#define __KinokoStorageHeader_hh__


#include <iostream>
#include <string>
#include <vector>
#include <map>


class TKinokoStorageHeader {
  public:
    TKinokoStorageHeader(void);
    virtual ~TKinokoStorageHeader();
    virtual void AddEntry(const std::string& Name, const std::string& Value);
    virtual unsigned NumberOfEntries(void) const;
    virtual std::string EntryNameAt(unsigned Index) const;
    virtual std::string ValueAt(unsigned Index) const;
    virtual std::string ValueOf(const std::string& Name) const;
    virtual void WriteTo(std::ostream& os, const std::string& Prefix = "") const;
  protected:
    std::vector<std::pair<std::string, std::string> > _HeaderEntryList;
    std::map<std::string, std::string> _HeaderEntryTable;
};


#endif
